package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 运维人员文件
 *
 * @author system_generator
 * @date 2024-03-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value ="hygf_maintenance_file",autoResultMap = true)
public class MaintenanceFile extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 运维人员id
     */
    @TableField("maintenance_id")
    private Long maintenanceId;

    /**
     * 文件标识
     */
    @TableField("file_key")
    private String fileKey;

    /**
     * 文件标识名称
     */
    @TableField("file_key_name")
    private String fileKeyName;

    /**
     * 文件对象
     */
    @TableField(value ="file_url", typeHandler = FastjsonTypeHandler.class)
    private List<Object> fileUrl;

    /**
     * 有效开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @TableField("effective_date_start")
    private Date effectiveDateStart;

    /**
     * 有效结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @TableField("effective_date_end")
    private Date effectiveDateEnd;

}
