package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 施工电站施工资料
 *
 * @author system_generator
 * @date 2024-01-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_power_station_construction_data",autoResultMap = true)
public class PowerStationConstructionData extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 
     */
	@TableField("work_order_id")
    private Long workOrderId;

    /**
     * 施工状态
     */
	@TableField("construction_status")
    private String constructionStatus;

    /**
     * 施工交底文件
     */
	@TableField(value ="construction_instructions_file",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  constructionInstructionsFile;

    /**
     * 劳动防护用品配置
     */
	@TableField(value ="labor_protection_equipment_config",typeHandler = FastjsonTypeHandler.class)
    private List<Object> laborProtectionEquipmentConfig;

    /**
     * 施工前安全措施保障视频
     */
	@TableField(value ="safety_precaution_video",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  safetyPrecautionVideo;

    /**
     * 支架整体图一
     */
	@TableField(value ="bracket_overall_plan1",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  bracketOverallPlan1;

    /**
     * 支架整体图二
     */
	@TableField(value ="bracket_overall_plan2",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  bracketOverallPlan2;

    /**
     * 方阵倾角测试照片/规模
     */
	@TableField(value ="array_inclination_test_photo",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  arrayInclinationTestPhoto;

    /**
     * 方阵整体图一（全景）
     */
	@TableField(value ="array_overall_plan1",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  arrayOverallPlan1;

    /**
     * 方阵整体图二
     */
	@TableField(value ="array_overall_plan2",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  arrayOverallPlan2;

    /**
     * 方阵整体图三
     */
	@TableField(value ="array_overall_plan3",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  arrayOverallPlan3;

    /**
     * 逆变器整体图
     */
	@TableField(value ="inverter_overall_plan",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  inverterOverallPlan;

    /**
     * 光伏电缆走线
     */
	@TableField(value ="photovoltaic_cable_routing",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  photovoltaicCableRouting;

    /**
     * 电表箱外部整体
     */
	@TableField(value ="electricity_meter_box_exterior",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  electricityMeterBoxExterior;

    /**
     * 电表箱内部整体
     */
	@TableField(value ="electricity_meter_box_interior",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  electricityMeterBoxInterior;

    /**
     * 支架接地
     */
	@TableField(value ="bracket_grounding",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  bracketGrounding;

    /**
     * 接地点
     */
	@TableField(value ="grounding_point",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  groundingPoint;

    /**
     * 交流电缆走线
     */
	@TableField(value ="ac_cable_routing",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  acCableRouting;

    /**
     * 其他照片
     */
	@TableField(value ="other_photos",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  otherPhotos;

    /**
     * 备案附件
     */
	@TableField(value ="archive_attachments",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  archiveAttachments;

    /**
     * 安装人员信息
     */
	@TableField(value ="installer_info",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  installerInfo;

    /**
     * 施工组件信息
     */
	@TableField(value ="construction_component_info",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  constructionComponentInfo;

    /**
     * 施工逆变器信息
     */
	@TableField(value ="construction_inverter_info",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  constructionInverterInfo;

    /**
     * 施工采集器信息
     */
	@TableField(value ="construction_collector_box_info",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  constructionCollectorBoxInfo;

    /**
     * 施工并网箱信息
     */
	@TableField(value = "construction_grid_box_info",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  constructionGridBoxInfo;

    /**
     * 
     */
	@TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 是否提交流程
     */
    @TableField(exist = false)
    private boolean commitFlow;

}
