package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/11/9
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "std_user_empower",autoResultMap = true)
public class StdUserEmpower extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 用户userid
     */
    @TableField("amos_user_id")
    private String amosUserId;

    /**
     * 单位orgcode
     */
    @TableField(value = "amos_org_code",typeHandler = FastjsonTypeHandler.class)
    private List<String> amosOrgCode;

    @TableField("permission_type")
    private String permissionType;

    /**
     * 外部选中单位orgcode
     */
    @TableField(value = "eliminate_amos_org_code",typeHandler = FastjsonTypeHandler.class)
    private List<String> eliminateAmosOrgCode;


    /**
     * 外部 不选中单位orgcode
     */
    @TableField(exist = false)
    private List<String> NOeliminateAmosOrgCode;



    //登录人id
    @TableField(exist = false)
    private String userId;

    //区域公司orgcode
    @TableField(exist = false)
    private String regionalCompaniesCode;

    //经销商业务单位id
    @TableField(exist = false)
    private Long developerId;


    //管理端 true，还是经销商false
    @TableField(exist = false)
    private boolean flag;

    //经销商管理员区域公司orgcode
    @TableField(exist = false)
    private String adminRegionalCompaniesCode;


    //是否农户
    @TableField(exist = false)
    private boolean farmer;
}
