package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

@Data
@TableName(value = "td_hygf_inverter_day_generate" ,autoResultMap = true)
public class TdHYGFInverterDayGenerate implements Serializable {
    /**
     * 创建时间
     */
    @ExcelIgnore
    private Long createdTime;

    /**
     * 创建时间
     */
    @ExcelProperty("时间")
    private String createdTimeStr;

    /**
     * 第三方场站id
     */
    @ExcelIgnore
    private String thirdStationId;
    /**
     * sncode
     */
    @ExcelProperty("SN")
    private String snCode;
    /**
     * 工作状态
     */
    @ExcelProperty("工作状态")
    private String workStatus;
    /**
     * 直流电压1
     */
    @ExcelProperty("直流电压1(V)")
    private Double acv1;
    /**
     * 直流电压2
     */
    @ExcelProperty("直流电压2(V)")
    private Double acv2;
    /**
     * 直流电压3
     */
    @ExcelProperty("直流电压3(V)")
    private Double acv3;
    /**
     * 直流电压4
     */
    @ExcelProperty("直流电压4(V)")
    private Double acv4;
    /**
     * 直流电流1
     */
    @ExcelProperty("直流电流1(A)")
    private Double acc1;
    /**
     * 直流电流2
     */
    @ExcelProperty("直流电流2(A)")
    private Double acc2;
    /**
     * 直流电流3
     */
    @ExcelProperty("直流电流3(A)")
    private Double acc3;
    /**
     * 直流电流4
     */
    @ExcelProperty("直流电流4(A)")
    private Double acc4;
    /**
     * 交流电压1
     */
    @ExcelProperty("交流电压U(V)")
    private Double dcv1;
    /**
     * 交流电压2
     */
    @ExcelProperty("交流电压V(V)")
    private Double dcv2;
    /**
     * 交流电压3
     */
    @ExcelProperty("交流电压W(V)")
    private Double dcv3;
    /**
     * 交流电压4
     */
    @ExcelIgnore
    private Double dcv4;
    /**
     * 交流电流1
     */
    @ExcelProperty("交流电流U(A)")
    private Double dcc1;
    /**
     * 交流电流2
     */
    @ExcelProperty("交流电流V(A)")
    private Double dcc2;
    /**
     * 交流电流3
     */
    @ExcelProperty("交流电流W(A)")
    private Double dcc3;
    /**
     * 交流电流4
     */
    @ExcelIgnore
    private Double dcc4;

    /**
     * 总功率
     */
    @ExcelProperty("总功率(kWh)")
    private Double totalPower;
    /**
     * 频率
     */
    @ExcelProperty("交流频率(Hz)")
    private String frequency;
    /**
     * 功率因数
     */
    @ExcelProperty("功率因数")
    private Double powerFactor;
    /**
     * 日发电量
     */
    @ExcelProperty("日发电量(kWh)")
    private Double dayGen;
    /**
     * 月发电量
     */
    @ExcelProperty("月发电量(kWh)")
    private Double monthGen;
    /**
     * 年发电量
     */
    @ExcelProperty("年发电量(kWh)")
    private Double yearGen;
    /**
     * 累计发电量
     */
    @ExcelProperty("总发电量(kWh)")
    private Double totalGen;
    /**
     * IGBT温度
     */
    @ExcelProperty("IGBT温度(℃)")
    private Double igbtTemp;

    /**
     * 直流功率1
     */
    @ExcelIgnore
    private Double pv1;
    /**
     * 直流功率2
     */
    @ExcelIgnore
    private Double pv2;
    /**
     * 直流功率3
     */
    @ExcelIgnore
    private Double pv3;
    /**
     * 直流功率4
     */
    @ExcelIgnore
    private Double pv4;
    @ExcelIgnore
    private Double income;
    @ExcelIgnore
    private Double fullhour;
    @ExcelIgnore
    private String name;
}

