package com.yeejoin.amos.boot.module.hygf.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.dto.PeasantHouseholdDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 农户信息 Mapper 接口
 *
 * @author system_generator
 * @date 2023-07-07
 */
public interface PeasantHouseholdMapper extends BaseMapper<PeasantHousehold> {
    List<PeasantHousehold> selectPeasantHouseholdList(@Param("developerId") Long developerId,
                                                      @Param("regionalCompaniesSeq")Long regionalCompaniesSeq,
                                                      @Param("peasantHouseholdNo")String peasantHouseholdNo,
                                                      @Param("ownersName")String ownersName,
                                                      @Param("ids")String ids
    );
    List<PeasantHousehold> selectPeasantHouseholdListsg(@Param("developerId") Long developerId,
                                                      @Param("regionalCompaniesSeq")Long regionalCompaniesSeq,
                                                      @Param("peasantHouseholdNo")String peasantHouseholdNo,
                                                      @Param("ownersName")String ownersName,
                                                        @Param("ids")String ids

    );
    @UserEmpower(field={},dealerField={"developer_code","regional_companies_code","developer_user_id"} ,fieldConditions ={"eq","in","eq"} ,relationship="and")
    List<PeasantHousehold> queryForPage( String developerCode,String ownersName,Long developerId,Integer isCertified,String preparationMoneyState);


    List<Map<String,Object>> selectUserIsHouse(String telephone);

    Integer selectIsAllRevoke(String amosUserId);

    void deleteHphByUserId(String userId);
    void deletePauByUserId(String userId);
    void deleteAliByUserId(String userId);
    void deleteHhcByUserId(String userId);

    Integer selectSurveyOrNot(String sequenceNbr);
}
