package com.yeejoin.amos.boot.module.hygf.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapBuilder;
import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.module.hygf.api.util.CommonResponseNewUtil;
import com.yeejoin.amos.boot.module.hygf.api.util.CommonResponseUtil;
import io.seata.spring.annotation.GlobalTransactional;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.FinancingInfoServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingInfoDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 
 *
 * @author system_generator
 * @date 2024-04-01
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/financing-info")
public class FinancingInfoController extends BaseController {

    @Autowired
    FinancingInfoServiceImpl financingInfoServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	@GlobalTransactional
	public ResponseModel<FinancingInfoDto> save(@RequestBody FinancingInfoDto model) {
	    model = financingInfoServiceImpl.saveModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	@GlobalTransactional
	public ResponseModel<FinancingInfoDto> updateBySequenceNbrFinancingInfo(@RequestBody FinancingInfoDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
		model.setFile(JSON.toJSONString(model.getFiles()));
		if (model.getFinancingCompaniesSeq() != null){
			Map<String, Object> orgInfo = financingInfoServiceImpl.getBaseMapper().selectRZOrgInfo(model.getFinancingCompaniesSeq());
			model.setFinancingCompaniesCode(orgInfo.getOrDefault("ORG_CODE", "").toString());
			model.setFinancingCompaniesName(orgInfo.getOrDefault("COMPANY_NAME", "").toString());
		}
		financingInfoServiceImpl.updateWithModel(model);
		if (null != model.getDisbursementMoney() && model.getStatus() != "放款完成" ){
			Map<String, Object> map = BeanUtil.beanToMap(model);
			map.put("approvalStatus","0");
			financingInfoServiceImpl.execueFlow(map);
		}
//		if  model.getStatus().equals("")){
//			Map<String, Object> map = BeanUtil.beanToMap(model);
//			map.put("approvalStatus","0");
//			financingInfoServiceImpl.execueFlow(map);
//		}
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(financingInfoServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<FinancingInfoDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(financingInfoServiceImpl.selectDataInfo(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<Map<String, Object>>> queryForPage(@RequestParam(value = "current") int current,@RequestParam(value = "size") int size,@RequestParam(value = "type") String type,
																 @RequestParam(value = "status",required = false) String status,
																 @RequestParam(value = "regionalCompaniesCode" ,required = false) String regionalCompaniesCode ,
																 @RequestParam(value = "ownersName",required = false) String ownersName){
	    Page<Map<String, Object>> page = new Page<Map<String, Object>>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(financingInfoServiceImpl.queryForFinancingInfoPage(page,type,status,regionalCompaniesCode,ownersName));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FinancingInfoDto>> selectForList() {
	    return ResponseHelper.buildResponse(financingInfoServiceImpl.queryForFinancingInfoList());
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "撤回",   notes = "撤回")
	@GlobalTransactional
	@GetMapping(value = "/rollback")
	public ResponseModel rollback(String instanceId,String peasantHouseholdId) {
		 financingInfoServiceImpl.rollback(instanceId,peasantHouseholdId);
		 return CommonResponseNewUtil.success();
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "审核",   notes = "审核")
	@PostMapping(value = "/execueFlow")
	@GlobalTransactional
	public ResponseModel execueFlow(@RequestBody Map<String, Object> params) {
		financingInfoServiceImpl.execueFlow(params);
		return CommonResponseNewUtil.success();
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "融资机构列表",   notes = "融资机构列表")
	@GetMapping(value = "/orgList")
	public ResponseModel<List<Map<String,Object>>> orgList() {
		return CommonResponseNewUtil.success(financingInfoServiceImpl.selectOrgList());
	}

}
