package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorHistoryAllDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorHistoryMonthDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorHistoryYearDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpCollectorHistoryDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.TdHygfJpCollectorHistoryServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

/**
 * 户用光伏监盘采集器历史表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@RestController
@Api(tags = "户用光伏监盘采集器历史表Api")
@RequestMapping(value = "/td-hygf-jp-collector-history")
public class TdHygfJpCollectorHistoryController extends BaseController {

	@Autowired
	TdHygfJpCollectorHistoryServiceImpl tdHygfJpCollectorHistoryServiceImpl;

	/**
	 * 新增户用光伏监盘采集器历史表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏监盘采集器历史表", notes = "新增户用光伏监盘采集器历史表")
	public ResponseModel<TdHygfJpCollectorHistoryDto> save(@RequestBody TdHygfJpCollectorHistoryDto model) {
		model = tdHygfJpCollectorHistoryServiceImpl.createWithModel(model);
		return ResponseHelper.buildResponse(model);
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏监盘采集器历史表", notes = "根据sequenceNbr更新户用光伏监盘采集器历史表")

	public ResponseModel<TdHygfJpCollectorHistoryDto> updateBySequenceNbrTdHygfJpCollectorHistory(
			@RequestBody TdHygfJpCollectorHistoryDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(tdHygfJpCollectorHistoryServiceImpl.updateWithModel(model));

	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏监盘采集器历史表", notes = "根据sequenceNbr删除户用光伏监盘采集器历史表")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
			@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(tdHygfJpCollectorHistoryServiceImpl.removeById(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个户用光伏监盘采集器历史表", notes = "根据sequenceNbr查询单个户用光伏监盘采集器历史表")
	public ResponseModel<TdHygfJpCollectorHistoryDto> selectOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(tdHygfJpCollectorHistoryServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘采集器历史表分页查询", notes = "户用光伏监盘采集器历史表分页查询")
	public ResponseModel<Page<TdHygfJpCollectorHistoryDto>> queryForPage(@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size) {
		Page<TdHygfJpCollectorHistoryDto> page = new Page<TdHygfJpCollectorHistoryDto>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper
				.buildResponse(tdHygfJpCollectorHistoryServiceImpl.queryForTdHygfJpCollectorHistoryPage(page));
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘采集器历史表列表全部数据查询", notes = "户用光伏监盘采集器历史表列表全部数据查询")
	@GetMapping(value = "/list/day")
	public ResponseModel<List<TdHygfJpCollectorHistoryDto>> dayList(@RequestParam(value = "id") long id,
			@RequestParam(value = "day") @DateTimeFormat(pattern = "yyyy-MM-dd") Date day) {
		return ResponseHelper.buildResponse(tdHygfJpCollectorHistoryServiceImpl.dayList(id, day));
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘采集器历史表列表全部数据查询", notes = "户用光伏监盘采集器历史表列表全部数据查询")
	@GetMapping(value = "/list/month")
	public ResponseModel<List<JpCollectorHistoryMonthDto>> monthList(@RequestParam(value = "id") long id,
			@RequestParam(value = "month") @DateTimeFormat(pattern = "yyyy-MM") Date month) {
		return ResponseHelper.buildResponse(tdHygfJpCollectorHistoryServiceImpl.monthList(id, month));
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘采集器历史表列表全部数据查询", notes = "户用光伏监盘采集器历史表列表全部数据查询")
	@GetMapping(value = "/list/year")
	public ResponseModel<List<JpCollectorHistoryYearDto>> yearList(@RequestParam(value = "id") long id,
			@RequestParam(value = "year") @DateTimeFormat(pattern = "yyyy") Date year) {
		return ResponseHelper.buildResponse(tdHygfJpCollectorHistoryServiceImpl.yearList(id, year));
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘采集器历史表列表全部数据查询", notes = "户用光伏监盘采集器历史表列表全部数据查询")
	@GetMapping(value = "/list/all")
	public ResponseModel<List<JpCollectorHistoryAllDto>> allList(@RequestParam(value = "id") long id) {
		return ResponseHelper.buildResponse(tdHygfJpCollectorHistoryServiceImpl.allList(id));
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘采集器历史表列表全部数据查询", notes = "户用光伏监盘采集器历史表列表全部数据查询")
	@GetMapping(value = "/syncData")
	public ResponseModel<Object> syncData() {
		return ResponseHelper.buildResponse(tdHygfJpCollectorHistoryServiceImpl.syncData());
	}
}
