package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.yeejoin.amos.boot.module.hygf.api.dto.StandardDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.StartProcessDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.BasicGridAcceptance;
import com.yeejoin.amos.boot.module.hygf.biz.feign.WorkflowFeignClient;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import io.seata.spring.annotation.GlobalTransactional;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestHeader;

import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2024/1/16
 */
@Service
public class WorkflowImpl {

    @Autowired
    WorkflowFeignClient workflowFeignClient;

   /**
    *
    * 发起工作流，并执行第一节点
    *
    * **/


     public BasicGridAcceptance startProcess(BasicGridAcceptance basicGridAcceptance,StartProcessDto startProcessDto,String userid){
        FeignClientResult<List<ProcessTaskDTO>> json=   workflowFeignClient.startProcess(startProcessDto);
         basicGridAcceptance= this.getBasicGridAcceptance(basicGridAcceptance,json,userid);
        return basicGridAcceptance;
    }
    public BasicGridAcceptance startProcessnew(
            String appKey,
            String product,
            String token,
            BasicGridAcceptance basicGridAcceptance,StartProcessDto startProcessDto,String userid){
        FeignClientResult<List<ProcessTaskDTO>> json=   workflowFeignClient.startProcessnew( appKey,
                product,
                token,
                startProcessDto);
        basicGridAcceptance= this.getBasicGridAcceptance(basicGridAcceptance,json,userid);
        return basicGridAcceptance;
    }

    /**
     *
     * 执行工作流
     *
     * */
    public BasicGridAcceptance standard(BasicGridAcceptance basicGridAcceptance,StandardDto standardDto,String userid){
        FeignClientResult<ProcessTaskDTO> json=null;
        if(standardDto.getResult()!=null){
            standardDto.setResultCode("approvalStatus");
            json= workflowFeignClient.standard(standardDto.getTaskId(),standardDto);
        }else{

            json= workflowFeignClient.standard(standardDto.getTaskId(),standardDto);
        }


        basicGridAcceptance= this.getBasicGridAcceptanceone(basicGridAcceptance,json,userid);
        return basicGridAcceptance;
    }

    public BasicGridAcceptance getBasicGridAcceptance(BasicGridAcceptance basicGridAcceptance,FeignClientResult<List<ProcessTaskDTO>> json,String userid){

        if (!ObjectUtils.isEmpty(json)) {
            if (json.getStatus() == 200) {
                List<ProcessTaskDTO>  lis = json.getResult();
                ProcessTaskDTO listco= lis.isEmpty()?null:lis.get(0);
                if(listco!=null){

                    //	当前节点执行任务id
                    basicGridAcceptance.setPromoter(userid);
                    //流程实例
                    basicGridAcceptance.setInstanceId(listco.getProcessInstance().getId());
                    //	流程下一节点id
                    if(listco.getNextTask()!=null&&!listco.getNextTask().isEmpty()){
                        basicGridAcceptance.setNextTaskId(listco.getNextTask().get(0).getId());
                        //下个节点名称
                        basicGridAcceptance.setNextNodeName(listco.getNextTask().get(0).getName());
                        //下个节点key
                        basicGridAcceptance.setNextNodeKey(listco.getNextTask().get(0).getKey());
                    }
                    ///	下一个节点角色权限
                    if(listco.getNextCandidateGroups()!=null){
                        List<String> ld= listco.getNextCandidateGroups().get(basicGridAcceptance.getNextTaskId());
                        StringBuffer sbf = new StringBuffer();
                        for(int i=0;i<=ld.size()-1;i++){
                            if(i<ld.size()-1){
                                sbf.append(ld.get(i) + ",");
                            }else {
                                sbf.append(ld.get(i));
                            }
                        }

                        basicGridAcceptance.setNextExecutorIds(sbf.toString());
                    }

                    //下一节点可执行人逗号分割	0	0
                    if(listco.getNextTaskExecutor()!=null){

                        List<AgencyUserModel> li=  listco.getNextTaskExecutor().get(basicGridAcceptance.getNextTaskId());
                        if(li!=null&&!li.isEmpty()){

                                StringBuffer sbf = new StringBuffer();
                                 for(int i=0;i<=li.size()-1;i++){
                                     if(i<li.size()-1){
                                         sbf.append(li.get(i).getUserId() + ",");
                                     }else {
                                         sbf.append(li.get(i).getUserId());
                                     }
                                 }
                            basicGridAcceptance.setNextExecuteUserIds(sbf.toString());
                        }
                    }
                    //工作流发起人id
                    basicGridAcceptance.setCreateUserId(listco.getStartUser().getUserId());

                }else{
                    throw new RuntimeException("工作流异常");
                }
            } else {
                throw new RuntimeException(json.getMessage());
            }
        }
    return basicGridAcceptance;
    }

    public BasicGridAcceptance getBasicGridAcceptanceone(BasicGridAcceptance basicGridAcceptance,FeignClientResult<ProcessTaskDTO> json,String userid){

        if (!ObjectUtils.isEmpty(json)) {
            if (json.getStatus() == 200) {
                ProcessTaskDTO listco = json.getResult();
                if(listco!=null){
                  

                    //	当前节点执行任务id
                    basicGridAcceptance.setPromoter(userid);

                    //	流程下一节点id
                    if(listco.getNextTask()!=null&&!listco.getNextTask().isEmpty()){
                        basicGridAcceptance.setNextTaskId(listco.getNextTask().get(0).getId());
                        //下个节点名称
                        basicGridAcceptance.setNextNodeName(listco.getNextTask().get(0).getName());
                        //下个节点key
                        basicGridAcceptance.setNextNodeKey(listco.getNextTask().get(0).getKey());
                    }else{
                        return basicGridAcceptance;
                    }
                    ///	下一个节点角色权限
                    if(listco.getNextCandidateGroups()!=null){
                        List<String> ld= listco.getNextCandidateGroups().get(basicGridAcceptance.getNextTaskId());
                        StringBuffer sbf = new StringBuffer();
                        for(int i=0;i<=ld.size()-1;i++){
                            if(i<ld.size()-1){
                                sbf.append(ld.get(i) + ",");
                            }else {
                                sbf.append(ld.get(i));
                            }
                        }

                        basicGridAcceptance.setNextExecutorIds(sbf.toString());
                    }

                    //下一节点可执行人逗号分割	0	0
                    if(listco.getNextTaskExecutor()!=null){

                        List<AgencyUserModel> li=  listco.getNextTaskExecutor().get(basicGridAcceptance.getNextTaskId());
                        if(li!=null&&!li.isEmpty()){

                            StringBuffer sbf = new StringBuffer();
                            for(int i=0;i<=li.size()-1;i++){
                                if(i<li.size()-1){
                                    sbf.append(li.get(i).getUserId() + ",");
                                }else {
                                    sbf.append(li.get(i).getUserId());
                                }
                            }
                            basicGridAcceptance.setNextExecuteUserIds(sbf.toString());
                        }
                    }

                }
            } else {
                throw new RuntimeException(json.getMessage());
            }
        }
        return basicGridAcceptance;
    }



}
