package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import cn.hutool.core.map.MapBuilder;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationBasicDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESMoonPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.constants.CommonConstans;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.CommonMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.EarningsForecastImpl;
import org.apache.http.client.HttpClient;
import org.elasticsearch.action.get.GetResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;

import static com.alibaba.fastjson.JSON.toJSONString;
import static java.lang.Boolean.TRUE;

@RestController
@RequestMapping("earningsForecast")
public class EarningsForecastController {

    @Autowired
    private StationBasicMapper stationBasicMapper;
    @Autowired
    private EarningsForecastImpl earningsForecast;

    @RequestMapping(value = "earningsForecast",method = RequestMethod.GET)
    @TycloudOperation(needAuth = false,ApiLevel = UserType.AGENCY)
    public ResponseModel<Object> earningsForecast (@RequestParam(required = true,value = "stationId") Long stationId,
                                                   @RequestParam(required = true,value = "type") String type){

        return  ResponseHelper.buildResponse(earningsForecast.earningsForecastZXT(stationId,type));

    }

    @RequestMapping(value = "earningsForecastSJQXT",method = RequestMethod.GET)
    @TycloudOperation(needAuth = false,ApiLevel = UserType.AGENCY)
    public ResponseModel<Object> earningsForecastSJQXT (@RequestParam(required = true,value = "stationId") Long stationId,
                                                   @RequestParam(required = true,value = "type") String type){

        return  ResponseHelper.buildResponse(earningsForecast.earningsForecastSJQXT(stationId,type));

    }




    @RequestMapping(value = "getStationListByArae",method = RequestMethod.GET)
    @TycloudOperation(needAuth = false,ApiLevel = UserType.AGENCY)
    public  ResponseModel<List<Map<String,Object>>>   getStationListByArae(String araeCode,String stationType){
        List<Map<String,Object>> maps = new ArrayList<>();

        if (stationType.equals("FDZ")){
            stationBasicMapper.getStationsByAreaCode(araeCode).stream().filter(a->a.getStationType().equals(stationType)).forEach(e->{
                maps.add(MapBuilder.<String,Object>create().put("text",e.getStationName()).put("value",e.getSequenceNbr()).build());
            });
        }else {
            stationBasicMapper.getStationsByAreaCode(araeCode).stream().filter(a->a.getStationType().contains(stationType)).forEach(e->{
                maps.add(MapBuilder.<String,Object>create().put("text",e.getStationName()).put("value",e.getSequenceNbr()).build());
            });
        }

      return   ResponseHelper.buildResponse(maps);
        }




}
