package com.yeejoin.amos.boot.module.jxiop.biz.scheduled;//package com.yeejoin.amos.boot.module.jxiop.biz.scheduled;

import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESDailyPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESMoonPowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.StationCacheInfoDto;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.PowerGenerationImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/8/9
 */

@Component
@EnableScheduling
public class PowerGeneration {

    private final String dayvalue = "日发电量";
    private final String moonValue = "月发电量";
    private final String yearValue = "年发电量";
    private final String dayDateFormat = "yyyy-MM-dd";
    private final String moonDateFormat = "yyyy-MM";
    private final String yearDateFormat = "yyyy";
    private final String dayType = "day";
    private final String moonType = "moon";
    private final String yearType = "year";
    @Autowired
    PowerGenerationImpl powerGenerationImpl;
    @Autowired
    CommonServiceImpl commonServiceImpl;

    @Async
    //定时更新日发电量
    @Scheduled(cron = "${daily.power.generation.cron}")
    public void addESDailyPowerGeneration() {
        List<StationCacheInfoDto> list = commonServiceImpl.getListStationCacheInfoDto();
        //获取时间天字符串
        SimpleDateFormat myFmt2 = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        String daty = myFmt2.format(now);
        for (StationCacheInfoDto stationCacheInfoDto : list) {

            if ("FDZ".equals(stationCacheInfoDto.getStationType())) {
                //风机
                powerGenerationImpl.addPowerGeneration(stationCacheInfoDto, stationCacheInfoDto.getFanGatewayId(), dayvalue, dayDateFormat, dayType, "FDZ", daty);
            } else {
                //光伏
                powerGenerationImpl.addPowerGeneration(stationCacheInfoDto, stationCacheInfoDto.getFanGatewayId(), dayvalue, dayDateFormat, dayType, "GFDZ", daty);
            }

        }


    }

    //定时更新月发电量
    @Async
    @Scheduled(cron = "${moon.power.generation.cron}")
    public void addESMoonPowerGeneration() {
        List<StationCacheInfoDto> list = commonServiceImpl.getListStationCacheInfoDto();
        //获取时间天字符串
        SimpleDateFormat myFmt2 = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        String daty = myFmt2.format(now);
        for (StationCacheInfoDto stationCacheInfoDto : list) {
            //风机
            if ("FDZ".equals(stationCacheInfoDto.getStationType())) {

                //风机
                powerGenerationImpl.addPowerGeneration(stationCacheInfoDto, stationCacheInfoDto.getFanGatewayId(), moonValue, moonDateFormat, moonType, "FDZ", daty);

            } else {

                //光伏
                powerGenerationImpl.addPowerGeneration(stationCacheInfoDto, stationCacheInfoDto.getFanGatewayId(), moonValue, moonDateFormat, moonType, "GFDZ", daty);

            }

        }
    }

    //定时更新年发电量
    @Async
    @Scheduled(cron = "${year.power.generation.cron}")
    public void addESYearPowerGeneration() {
        List<StationCacheInfoDto> list = commonServiceImpl.getListStationCacheInfoDto();
        //获取时间天字符串
        SimpleDateFormat myFmt2 = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        String daty = myFmt2.format(now);
        for (StationCacheInfoDto stationCacheInfoDto : list) {
            //风机
            if ("FDZ".equals(stationCacheInfoDto.getStationType())) {

                //风机
                powerGenerationImpl.addPowerGeneration(stationCacheInfoDto, stationCacheInfoDto.getFanGatewayId(), yearValue, yearDateFormat, yearType, "FDZ", daty);

            } else {

                //光伏
                powerGenerationImpl.addPowerGeneration(stationCacheInfoDto, stationCacheInfoDto.getFanGatewayId(), yearValue, yearDateFormat, yearType, "GFDZ", daty);

            }

        }
    }

}
