package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.YwpgModuleInfoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@RestController
@Api(tags = "JXIOP认证")
@RequestMapping(value = "/auth")
public class JxiopAuthController extends BaseController {

    @Autowired
    YwpgModuleInfoServiceImpl ywpgModuleInfoService;
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/v1")
    @ApiOperation(httpMethod = "GET", value = "运维评模块数据过滤", notes = "运维评估模块数据过滤")
    public ResponseModel<List<Map<String,Object>>> getIdxAuthInfo() {
       ReginParams reginParams =getSelectedOrgInfo();
        return ResponseHelper.buildResponse(ywpgModuleInfoService.getIdxAuthInfo(reginParams));
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getJxiopOrgCode")
    @ApiOperation(httpMethod = "GET", value = "运维评模块数据过滤", notes = "运维评估模块数据过滤")
    public ResponseModel<String> getJxiopOrgCode() {
        ReginParams reginParams =getSelectedOrgInfo();
        return ResponseHelper.buildResponse(ywpgModuleInfoService.getJxiopOrgCode(reginParams));
    }
}
