package com.yeejoin.amos.boot.module.jxiop.biz.config;


import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.github.pagehelper.PageInterceptor;

import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import java.util.Properties;

import javax.sql.DataSource;

/**
 * 从数据源配置
 * 若需要配置更多数据源 , 直接在yml中添加数据源配置再增加相应的新的数据源配置类即可
 */
@Configuration
@MapperScan(basePackages = "com.yeejoin.amos.boot.module.jxiop.biz.tdmapper", sqlSessionFactoryRef = "taosSqlSessionFactory")
public class TdEngineConfig {
    private Logger logger = LoggerFactory.getLogger(TdEngineConfig.class);
    // 精确到 cluster 目录，以便跟其他数据源隔离
    private static final String MAPPER_LOCATION = "classpath*:mapper/tdengine/*.xml";


    @Value("${spring.db3.datasource.url}")
    private String dbUrl;

    @Value("${spring.db3.datasource.username}")
    private String username;

    @Value("${spring.db3.datasource.password}")
    private String password;

    @Value("${spring.db3.datasource.driver-class-name}")
    private String driverClassName;


    @Bean(name = "taosDataSource")   //声明其为Bean实例
    public DataSource clusterDataSource() {
        DruidDataSource datasource = new DruidDataSource();

        datasource.setUrl(this.dbUrl);
        datasource.setUsername(username);
        datasource.setPassword(password);
        datasource.setDriverClassName(driverClassName);
        return datasource;
    }

    @Bean(name = "taosTransactionManager")
    public DataSourceTransactionManager clusterTransactionManager() {
        return new DataSourceTransactionManager(clusterDataSource());
    }

    @Bean(name = "taosSqlSessionFactory")
    public SqlSessionFactory clusterSqlSessionFactory(@Qualifier("taosDataSource") DataSource culsterDataSource)
            throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(culsterDataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(MAPPER_LOCATION));

        //分页插件
        Interceptor interceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("helperDialect", "mysql");
        properties.setProperty("offsetAsPageNum", "true");
        properties.setProperty("rowBoundsWithCount", "true");
        properties.setProperty("reasonable", "true");
        properties.setProperty("supportMethodsArguments","true");
        properties.setProperty("params","pageNum=pageNum;pageSize=pageSize" +
                "" +
                ";");
        interceptor.setProperties(properties);
        bean.setPlugins(new Interceptor[] {interceptor,paginationInterceptor()});
        return bean.getObject();
    }
    
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        return paginationInterceptor;
    }
}

