package com.yeejoin.amos.boot.module.common.api.service;

import java.util.List;

import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.Menu;
import com.yeejoin.amos.boot.module.common.api.dto.LinkageUnitDto;
import com.yeejoin.amos.boot.module.common.api.dto.LinkageUnitZhDto;
import com.yeejoin.amos.boot.module.common.api.dto.RequestData;
import com.yeejoin.amos.boot.module.common.api.entity.LinkageUnit;

/**
 * 联动单位接口类
 *
 * @author system_generator
 * @date 2021-07-16
 */
public interface ILinkageUnitService {

	List<LinkageUnitZhDto> listLinkageUnitZhDto(Integer pageNum, Integer pageSize, RequestData par);

	Integer listLinkageUnitZhDtoCount(RequestData par);

	LinkageUnitDto queryOne(Long sequenceNbr);

	/**
	 * 联动单位分页查询
	 *
	 * @param page
	 * @param isDelete
	 * @param unitName                 单位名称
	 * @param linkageUnitType          联动单位类型
	 * @param emergencyLinkageUnitCode 紧急联动单位类型code
	 * @return
	 */
	Page<LinkageUnitDto> queryForLinkageUnitPage(IPage<LinkageUnitDto> page,
            @Condition(Operator.eq) Boolean isDelete,
            @Condition(Operator.like) String unitName,
            @Condition(Operator.eq) String linkageUnitTypeCode,
            @Condition(Operator.eq) String emergencyLinkageUnitCode, 
            String inAgreement);
	/**
	 * 获取当前存在的联动单位的类型组code
	 * @return
	 */
	public  List<Menu> getEmergencyLinkageUnitCodeGroupBy(String type, String rootName) ;

}
