package com.yeejoin.amos.maintenance.common.enums;

import java.util.ArrayList;
import java.util.List;

public enum MsgSubscribeTypeEnum {

	PLANBEGIN("planBegin", 1),
	PLANWARN("planWarn", 2),
	PLANEND("planEnd", 3),
	CHECKTYPE("checkType", 4),
	CHECKEMAIL("checkEmail", 5),
	ROUTE("route", 6);
	
	private String name;
	
	private int value;
	
	private MsgSubscribeTypeEnum(String name, int value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getName(int value) {
		for (MsgSubscribeTypeEnum c : MsgSubscribeTypeEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}
	
	public static int getValue(String name) {
		for (MsgSubscribeTypeEnum c : MsgSubscribeTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return -1;
	}


	public static MsgSubscribeTypeEnum getEnum(int value) {
		for (MsgSubscribeTypeEnum c : MsgSubscribeTypeEnum.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
	}


	public static MsgSubscribeTypeEnum getEnum(String name) {
		for (MsgSubscribeTypeEnum c : MsgSubscribeTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<String> getEnumNameList() {
		List<String> nameList = new ArrayList<String>();
		for (MsgSubscribeTypeEnum c: MsgSubscribeTypeEnum.values()) {
			nameList.add(c.getName());
		}
		return nameList;
	}
	
	public int getValue() {
		return value;
	}

	public void setValue(int value) {
		this.value = value;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

}
