package com.yeejoin.amos.boot.module.common.biz.controller;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.OrgMenuDto;
import com.yeejoin.amos.boot.module.common.api.entity.MaintenanceCompany;
import com.yeejoin.amos.boot.module.common.api.service.IMaintenanceCompanyService;
import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.common.biz.service.impl.MaintenanceCompanyServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.utils.MyException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 维保单位
 *
 * @author system_generator
 * @date 2021-07-16
 */
@RestController
@Api(tags = "维保单位Api")
@RequestMapping(value = "/common/maintenance-company")
public class MaintenanceCompanyController extends BaseController {

	@Autowired
	MaintenanceCompanyServiceImpl maintenanceCompanyServiceImpl;

	@Autowired
	IMaintenanceCompanyService maintenanceCompanyService;

	private static final String COMPANY = "COMPANY";
	private static final String PERSON = "PERSON";
	private static final String DEPARTMENT = "DEPARTMENT";

	@Autowired
	IOrgUsrService iOrgUsrService;

	/**
	 * 新增维保单位
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/company/save")
	@ApiOperation(httpMethod = "POST", value = "新增维保单位", notes = "新增维保单位")
	public ResponseModel<Boolean> saveMaintenanceCompany(@RequestBody MaintenanceCompany model) {
		model.setType(COMPANY);
		return ResponseHelper.buildResponse(maintenanceCompanyService.saveCompanyDetail(model));
	}

	/**
	 * 新增维保单位人员基本信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/person/save")
	@ApiOperation(httpMethod = "POST", value = "新增维保人员", notes = "新增维保人员")
	public ResponseModel<Boolean> saveMaintenancePerson(@RequestBody MaintenanceCompany model) {
		model.setType(PERSON);
		return ResponseHelper.buildResponse(maintenanceCompanyService.savePersonDetail(model));
	}

	/**
	 * 检查员工编号是否已经存在，用于手动输入的员工编号校验
	 *
	 * @return
	 * @throws MyException
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/person/check/{personCode}")
	@ApiOperation(httpMethod = "POST", value = "校验员工编号", notes = "校验员工编号")
	public ResponseModel<Boolean> checkPersonCodeExists(@PathVariable String personCode) {

		boolean flag = maintenanceCompanyService.checkPersonCodeExists(personCode);

		if (flag) {
			return ResponseHelper.buildResponse(true);
		}
		return ResponseHelper.buildResponse(false);
	}

	/**
	 * 查询所有的维保人员/单位/部门信息的列表，不分页
	 * 
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/allList")
	@ApiOperation(httpMethod = "GET", value = "所有维保人员/单位/部门列表，不分页", notes = "所有维保人员列表")
	public ResponseModel<List<Map<String, Object>>> getAllMaintenanceList(@RequestParam String maintenanceType) {
		return ResponseHelper.buildResponse(maintenanceCompanyService.getAllMaintenanceList(maintenanceType));
	}

	/**
	 * 查询当前登陆用户所在维保单位下的维保人员列表，不分页
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/simple/list")
	@ApiOperation(httpMethod = "GET", value = "查询当前登陆用户所在维保单位下的维保人员列表部门列表，不分页", notes = "查询当前登陆用户所在维保单位下的维保人员列表，不分页")
	public ResponseModel<List<Map<String, Object>>> getPersonListByCompanyId(@RequestParam(required = false) Long companyId) {
		AgencyUserModel amosUser = getUserInfo();
		List<Map<String, Object>> result = maintenanceCompanyServiceImpl.getPersonListByCompanyId(companyId,
				amosUser.getUserId());
		return ResponseHelper.buildResponse(result);
	}

	/**
	 * 查询所有的维保人员/单位/部门信息的列表，不分页
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/page/List")
	@ApiOperation(httpMethod = "POST", value = "所有维保人员/单位/部门分页列表", notes = "所有维保人员列表")
	public ResponseModel<IPage<Map<String, Object>>> getPageMaintenanceList(@RequestBody Map<String, Object> paramsMap) {
		return ResponseHelper.buildResponse(maintenanceCompanyService.getPageMaintenanceList(paramsMap));
	}

	/**
	 * 新增维保单位部门基本信息
	 *
	 * @return
	 * @throws MyException
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/department/save")
	@ApiOperation(httpMethod = "POST", value = "新增维保部门", notes = "新增维保部门")
	public ResponseModel<Boolean> saveMaintenanceDepartment(@RequestBody MaintenanceCompany model) {
		model.setType(DEPARTMENT);
		return ResponseHelper.buildResponse(maintenanceCompanyService.saveDepartmentDetail(model));
	}

	/**
	 * 获取公司名称的下拉列表
	 * 
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getCompanyDropDownList")
	@ApiOperation(httpMethod = "GET", value = "查询公司名称下拉列表", notes = "查询公司名称下拉列表")
	public ResponseModel<List<Map<String, Object>>> getMaintenanceCompanyDropDownList() {
		List<Map<String, Object>> result = maintenanceCompanyService.getMaintenanceCompanyDropDownList();
		return ResponseHelper.buildResponse(result);
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @param model 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "put/company")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新维保单位", notes = "根据sequenceNbr更新维保单位")
	public ResponseModel<Boolean> updateBySequenceNbrMaintenanceCompany(@RequestBody MaintenanceCompany model) throws Exception {
		return ResponseHelper
				.buildResponse(maintenanceCompanyService.updateMaintenanceCompanyDetail(model));
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @param model 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "put/person")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新维保单位人员", notes = "根据sequenceNbr更新维保单位")
	public ResponseModel<Boolean> updateBySequenceNbrMaintenancePerson(@RequestBody MaintenanceCompany model) throws Exception {
		return ResponseHelper
				.buildResponse(maintenanceCompanyService.updateMaintenancePersonDetail(model));
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @param model 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "put/department")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新维保单位部门", notes = "根据sequenceNbr更新维保单位")
	public ResponseModel<Boolean> updateBySequenceNbrMaintenanceDepartment(@RequestBody MaintenanceCompany model
			) throws Exception {
		return ResponseHelper
				.buildResponse(maintenanceCompanyService.updateMaintenanceDepartmentDetail(model));
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "delete/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
			@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(maintenanceCompanyService.deleteById(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "find")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个维保单位-人员-部门", notes = "根据sequenceNbr查询单个维保单位-人员-部门")
	public ResponseModel<Map<String, Object>> selectOne(@RequestParam long sequenceNbr) {
		return ResponseHelper.buildResponse(maintenanceCompanyService.findBySequenceNbr(sequenceNbr));
	}

	/**
	 * 查询单位-部门树结构数据
	 *
	 * @return
	 * @throws Exception
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "companyAndDepartment/getTree")
	@ApiOperation(httpMethod = "GET", value = "查询单位-部门树结构数据", notes = "查询单位-部门树结构数据")
	public ResponseModel<List<OrgMenuDto>> getCompanyAndDepartmentTree() throws Exception {
		List<OrgMenuDto> menus = iOrgUsrService.getTree(null,
				maintenanceCompanyService.getCompanyAndDepartmentTree(), MaintenanceCompany.class.getName(),
				"getSequenceNbr", 2, "getName", "getParentId", "getType");
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 查询单位-部门树结构数据
	 *
	 * @return
	 * @throws Exception
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "departmentAndPerson/getTree")
	@ApiOperation(httpMethod = "GET", value = "查询部门-人树结构数据", notes = "查询部门-人树结构数据")
	public ResponseModel<List<OrgMenuDto>> getDepartmentTree(@RequestParam long sequenceNbr) throws Exception {
		List<OrgMenuDto> menus = iOrgUsrService.getTree(sequenceNbr,
				maintenanceCompanyService.getDepartmentAndPersonTree(sequenceNbr), MaintenanceCompany.class.getName(),
				"getSequenceNbr", 2, "getName", "getParentId", "getType");
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 查询单位-部门树结构数据
	 *
	 * @return
	 * @throws Exception
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getDepartmentList")
	@ApiOperation(httpMethod = "GET", value = "查询部门下拉列表数据", notes = "查询部门下拉列表数据")
	public ResponseModel<List<OrgMenuDto>> getDepartmentList(@RequestParam long sequenceNbr) throws Exception {
		List<OrgMenuDto> menus = iOrgUsrService.getTree(sequenceNbr,
				maintenanceCompanyService.getDepartmentList(sequenceNbr), MaintenanceCompany.class.getName(),
				"getSequenceNbr", 2, "getName", "getParentId", "getType");
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 根据维保单位查询所有机场单位(不带分页)
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "queryCompany/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据维保单位查询所有机场单位(不带分页)", notes = "根据维保单位查询所有机场单位(不带分页)")
	public ResponseModel<List<Map<String, Object>>> seleteCompanys(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(maintenanceCompanyServiceImpl.queryOrgUsrMsg(sequenceNbr));
	}

	/**
	 * 根据维保单位查询所有机场单位(带分页)
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "queryCompanyPages")
	@ApiOperation(httpMethod = "GET", value = "根据维保单位查询所有机场单位(带分页)", notes = "根据维保单位查询所有机场单位(带分页)")
	public ResponseModel<Page<Map<String, Object>>> selectCompanyPages(@RequestParam(required = false, defaultValue =
			"10", value = "pageNum") int pageNum, @RequestParam(value = "pageSize") int pageSize,
																	   @RequestParam(required = false) Long sequenceNbr) {
		AgencyUserModel amosUser = getUserInfo();
		return ResponseHelper
				.buildResponse(maintenanceCompanyServiceImpl.queryOrgUsrMsgPage(pageNum, pageSize, sequenceNbr,
						amosUser.getUserId()));
	}

	/**
	 *
	 * 查询维保单位、业主单位信息
	 * 
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询维保单位、业主单位信息", notes = "查询维保单位、业主单位信息")
	@GetMapping(value = "/companyList")
	public ResponseModel<List<Map<String, Object>>> selectCompanyList() {
		return ResponseHelper.buildResponse(maintenanceCompanyServiceImpl.queryCompanyMsg());
	}

}
