package com.yeejoin.amos.patrol.business.controller;


import java.util.HashMap;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.patrol.business.service.intfc.IEquipmentHandlerService;
import com.yeejoin.amos.patrol.business.util.CommonResponse;
import com.yeejoin.amos.patrol.business.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.business.util.Toke;
import org.typroject.tyboot.core.foundation.enumeration.UserType; import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import com.yeejoin.amos.patrol.dao.entity.InputItem;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 任务
 * @author wujunkai
 *
 */
@RestController
@RequestMapping(value = "/api/equipmnetRule")
@Api(tags="装备检查项")
public class EquipmentRuleController extends AbstractBaseController{
	private final Logger log = LoggerFactory.getLogger(EquipmentRuleController.class);

	@Autowired
	private IEquipmentHandlerService equipmentHandlerService;
	/**
	 * 装备检查项
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "装备检查项", notes = "装备检查项")
	@RequestMapping(value = "/equipmnetInput", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
	public CommonResponse getPlanTaskList(
			@ApiParam(value = "检查项请求参数", required = false) @RequestBody(required = true) HashMap<String,Object> map) {
		Toke token  =  new Toke();
		token.setProduct(request.getHeader("product"));
		token.setToke(request.getHeader("X-Access-Token"));
		token.setAppKey(request.getHeader("appKey"));
		ReginParams reginParams = getSelectedOrgInfo();
		String orgCode = getLoginOrgCode(reginParams);
		map.put("orgCode",orgCode);
		equipmentHandlerService.fireEquipRuleMessagePush(map,token);
		return CommonResponseUtil.success();
	}
	/**
	 * 装备检查项
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "装备检查项", notes = "装备检查项")
	@RequestMapping(value = "/getEquipmnetRules", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	public CommonResponse getEquipmnetRules(
			@ApiParam(value = "装备名称", required = true) @RequestParam(required = true) String equipmentName) {
//		ReginParams reginParams = getSelectedOrgInfo();
//		String orgCode = getLoginOrgCode(reginParams);
//		HashMap<String, Object> param = new HashMap<>();
//		param.put("equipmentName",equipmentName);
//		param.put("classifyId",classifyId);
//		param.put("orgCode",orgCode);
		List<InputItem> list=equipmentHandlerService.getEquipmnetRulesByName(equipmentName);
		return CommonResponseUtil.success(list);
	}

}
