package com.yeejoin.amos.patrol.business.controller;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.feign.privilege.model.IdPasswordAuthModel;
import com.yeejoin.amos.patrol.business.param.AppLoginUserParam;
import com.yeejoin.amos.patrol.business.service.intfc.IAppService;
import com.yeejoin.amos.patrol.business.util.CommonResponse;
import com.yeejoin.amos.patrol.business.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.business.util.DepartmentUserTreeAppVo;
import com.yeejoin.amos.patrol.business.util.DepartmentUserTreeWebVo;
import com.yeejoin.amos.patrol.business.util.DesUtil;
import com.yeejoin.amos.patrol.business.util.StringUtil;
import org.typroject.tyboot.core.foundation.enumeration.UserType; import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import com.yeejoin.amos.patrol.feign.RemoteSecurityService;
import com.yeejoin.amos.patrol.jpush.AppMessagePushService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 获取用户信息
 *
 * @author gaodongdong
 */
@RestController
@RequestMapping(value = "/api/user")
@Api(tags = "用户信息api")
public class UserController extends AbstractBaseController {
    private final Logger logger = LoggerFactory.getLogger(UserController.class);

   
    @Autowired
    private IAppService iAppService;
    @Autowired
    private Environment env;
    private static final String appType = "APP";
    @Autowired
    private RemoteSecurityService remoteSecurityService;
    @Autowired
    private AppMessagePushService appMessagePushService;

    @Value("${Security.fegin.name}")
    private String SecurityName;
    @Value("${security.productApp}")
    private String productApp;
    @Value("${security.appKey}")
    private String appKey;
    @Autowired
    private RestTemplate restTemplate;


    /**
     * 根据部门id查询用户信息
     *
     * @param deptId
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "部门人员查询", notes = "部门人员查询")
    @RequestMapping(value = "/queryDeptUser", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryDeptUser(@RequestParam(value = "deptId", required = false) String deptId) {

    	 List<AgencyUserModel> userModels = remoteSecurityService.listUserByDepartmentId(getToken(), getProduct(), getAppKey(), deptId);
    	 List<LinkedHashMap<String, Object>> userList =new ArrayList<>();
        if("-1".equals(deptId)){
    		 ReginParams reginParams = getSelectedOrgInfo();
 	        String dep = reginParams.getCompany().getSequenceNbr().toString();
    		//查询没有部门的人员信息
 	        CompanyModel companyModel = remoteSecurityService.listUserByCompanyId1(getToken(), getProduct(), getAppKey(), dep);

 	        List children = (List) companyModel.getChildren();


 	        for (int i = 0; i < children.size(); i++) {
 	            Map<String, Object> map = (LinkedHashMap) children.get(i);
 	            if("其他".equals((map.get("departmentName").toString()))){
 	            	 List<LinkedHashMap<String, Object>> user1 = (List<LinkedHashMap<String, Object>>) map.get("userModelList");

 	            	 for (int j = 0; j < user1.size(); j++) {
 	            		 LinkedHashMap<String, Object> user = new LinkedHashMap<>();
 	                    user.put("id", user1.get(j).get("userId").toString());
 	                    user.put("key", user1.get(j).get("userId").toString());
 	                    user.put("value", user1.get(j).get("userId").toString());
 	                    user.put("checked", false);
 	                    user.put("state", "open");
 	                    user.put("name", user1.get(j).get("realName").toString());
 	                    user.put("desc", null);
 	                    user.put("writeable", 0);
 	                    user.put("userName", user1.get(j).get("realName").toString());
                         if(StringUtil.isNotEmpty( user1.get(j).get("mobile"))){
                             user.put("mobile", user1.get(j).get("mobile").toString());
                         }else {
                             user.put("mobile", "");
                         }
 	                    if(StringUtil.isNotEmpty( user1.get(j).get("landlinePhone"))){
                            user.put("telephone", user1.get(j).get("landlinePhone").toString());
                        }else {
                            user.put("telephone", "");
                        }

 	                    user.put("departmentName", "其他");
 	                   userList.add(user);
					}

 	            }
 	        }
    	 }else{
    		 userList = paraseData(userModels, null).stream().distinct().collect(Collectors.toList());
    	 }
            return CommonResponseUtil.success(userList);
        }

    private List<LinkedHashMap<String, Object>> paraseData(List<AgencyUserModel> list, String userNmae) {
        List<LinkedHashMap<String, Object>> userList = new ArrayList<>();
        if (!ObjectUtils.isEmpty(list)) {
            for (AgencyUserModel userModel : list) {
                LinkedHashMap<String, Object> user = new LinkedHashMap<>();
                user.put("id", userModel.getUserId().toString());
                user.put("key", userModel.getUserId().toString());
                user.put("value", userModel.getUserId().toString());
                user.put("checked", false);
                user.put("state", "open");
                user.put("name", userModel.getRealName());
                user.put("desc", null);
                user.put("writeable", 0);
                user.put("userName", userModel.getUserId().toString());
                user.put("mobile", userModel.getMobile());
                user.put("telephone", userModel.getLandlinePhone());
                user.put("departmentName", "其他");
               userList.add(user);

            }
        }

        return userList;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "部门人员树查询", notes = "部门人员树查询")
    @RequestMapping(value = "/queryDeptUserTree1", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryDeptUserTree1() {
        ReginParams reginParams = getSelectedOrgInfo();
        CompanyModel companyModel = remoteSecurityService.listUserByCompanyId1(getToken(), getProduct(), getAppKey(), reginParams.getCompany().getSequenceNbr().toString());
        List children = (List) companyModel.getChildren();
        List<DepartmentUserTreeWebVo> list = Lists.newArrayList();
        String loginOrgCode= getLoginOrgCode(reginParams);
        for (int i = 0; i < children.size(); i++) {
            Map<String, Object> map = (LinkedHashMap) children.get(i);
            JSONObject json = JSON.parseObject(JSON.toJSONString(map));
            DepartmentUserTreeWebVo deptTreeWeb = new DepartmentUserTreeWebVo();
            JSONArray childrens = json.getJSONArray("children");

            deptTreeWeb.setType("department");
            deptTreeWeb.setKey(map.get("sequenceNbr").toString());
            deptTreeWeb.setLabel(map.get("sequenceNbr").toString());
            deptTreeWeb.setTitle(map.get("departmentName").toString());
            deptTreeWeb.setValue(map.get("sequenceNbr").toString());
            if (!ObjectUtils.isEmpty(map.get("userModelList"))) {
                List userModalList= (List) ((List) map.get("userModelList")).stream().distinct().collect(Collectors.toList());

                deptTreeWeb.setUserModelList(userModalList);
            }
            list.add(deptTreeWeb);
            if (childrens != null && childrens.size() > 0) {
                buildUserDeptTreeForWebBefore(list, childrens);
            }
        list = buildUserDeptTreeForWeb(list);

    }
        return CommonResponseUtil.success(list);
    }

    /**
     * 重构数据，用户存放在部门的children
     *
     * @param list
     * @return
     */
    private List<DepartmentUserTreeWebVo> buildUserDeptTreeForWeb(List<DepartmentUserTreeWebVo> list) {
        list.forEach(
          x -> {
              List<DepartmentUserTreeWebVo> users = Lists.newArrayList();

              if (!ObjectUtils.isEmpty(x.getUserModelList())) {

                  List<DepartmentUserTreeWebVo> collects = x.getUserModelList().stream().collect(Collectors.toList());
                  List<Map<String, Object>> userModelList = (List)collects;

                  userModelList.forEach(
                    userModel -> {
                        DepartmentUserTreeWebVo userTreeWeb = new DepartmentUserTreeWebVo();

                        userTreeWeb.setType("user");
                        userTreeWeb.setKey(userModel.get("userId").toString()+"*"+x.getValue()+"*"+UUID.randomUUID().toString());
                        userTreeWeb.setLabel(userModel.get("realName").toString());
                        userTreeWeb.setTitle(userModel.get("realName").toString());
                        userTreeWeb.setValue(userModel.get("userId").toString()+"*"+x.getValue()+"*"+UUID.randomUUID().toString());
                        users.add(userTreeWeb);
                    }
                  );
                  x.setChildren(users);
                  collects.clear();
                  x.setUserModelList(collects);
              }
          }
        );
        return list;
    }
    /**
     * 部门数据预处理（获取所有子节点）
     *
     * @param list
     * @param children
     */
    private void buildUserDeptTreeForWebBefore(List<DepartmentUserTreeWebVo> list, JSONArray children) {
        for (int i = 0; i < children.size(); i++) {
            JSONObject json = children.getJSONObject(i);

            DepartmentUserTreeWebVo deptTreeWeb = new DepartmentUserTreeWebVo();

            Map deptMap = JSONObject.parseObject(json.toJSONString(), Map.class);
            deptTreeWeb.setType("department");
            deptTreeWeb.setKey(deptMap.get("sequenceNbr").toString());
            deptTreeWeb.setLabel(deptMap.get("sequenceNbr").toString());
            deptTreeWeb.setTitle(deptMap.get("departmentName").toString());
            deptTreeWeb.setValue(deptMap.get("sequenceNbr").toString());
            if (!ObjectUtils.isEmpty(deptMap.get("userModelList"))) {
                deptTreeWeb.setUserModelList((List) deptMap.get("userModelList"));
            }

            if (json != null && json.size() > 0) {
                list.add(deptTreeWeb);
            } else {

                JSONArray childrens = json.getJSONArray("children");
                if (childrens != null && childrens.size() > 0) {
                    buildUserDeptTreeForWebBefore(deptTreeWeb.getChildren(), childrens);
                }
                if ("0".equals(deptMap.get("parentId"))) {
                    list.add(deptTreeWeb);
                }
            }
        }
    }





    /**
     * 查询用户权限人员
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "人员查询", notes = "人员查询")
    @RequestMapping(value = "/queryAuthUsers", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    // @Authorization(ingore = true)
    public CommonResponse queryAllUser() {

        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        List<AgencyUserModel> userModels = remoteSecurityService.listUserByOrgCode(getToken(), getProduct(), getAppKey(), loginOrgCode);
        List<LinkedHashMap<String, Object>> userList = paraseData(userModels, null);
        return CommonResponseUtil.success(userList);
    }

    /**
     * 查询用户部门人员树
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "部门人员树查询", notes = "部门人员树查询")
    @RequestMapping(value = "/queryDeptUserTree", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryDeptUserTree() {

    	 ReginParams reginParams = getSelectedOrgInfo();
         String departmentId = getDepartmentId(reginParams);
         List<AgencyUserModel> userModels = remoteSecurityService.listUserByDepartmentId(getToken(), getProduct(), getAppKey(), departmentId);
         List<LinkedHashMap<String, Object>> userList = paraseData(userModels, null);
         return CommonResponseUtil.success(userList);
    }

    /**
     * 查询用户部门人员树
     *
     * @return
     * @RequestParam userName 用户名
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "通讯录(<font color='blue'>手机app</font>)", notes = "通讯录(<font color='blue'>手机app</font>)")
    @RequestMapping(value = "/queryUserAddressList", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryUserAddressListTree(
            @ApiParam(value = "用户名", required = false) @RequestParam(value = "userName", required = false) String userName) {
          try {
              ReginParams reginParams = getSelectedOrgInfo();
              CompanyBo companyBo = reginParams.getCompany();
              JSONArray arr = remoteSecurityService.listDepartmentUserTree(getToken(), getProduct(), getAppKey(), companyBo.getSequenceNbr().toString());
              DepartmentUserTreeAppVo departmentUserTreeDto = new DepartmentUserTreeAppVo();
              if (arr != null && arr.size() > 0) {
                  buildUserDeptTree(departmentUserTreeDto, arr);
              }

              List<LinkedHashMap<String, Object>> content = new ArrayList<>();
              //数据重新封装
              List<DepartmentUserTreeAppVo>  list =   departmentUserTreeDto.getChildren();
              LinkedHashMap<String, Object> otherDept1 = new LinkedHashMap<>();
             for (DepartmentUserTreeAppVo departmentUserTreeAppVo : list) {
                 LinkedHashMap<String, Object> otherDept = new LinkedHashMap<>();

            	 if("其他".equals(departmentUserTreeAppVo.getName())){
            		 otherDept1.put("children", paraseData1(getToken(), getProduct(), getAppKey(),departmentUserTreeAppVo.getChildren(),"其他", "-1",userName));
                     otherDept1.put("id", -1);
                     otherDept1.put("key", -1);
                     otherDept1.put("value", -1);
                     otherDept1.put("state", "open");
                     otherDept1.put("type", "department");
                     otherDept1.put("label", "其他");
                     otherDept1.put("title", "其他");
                     otherDept1.put("name", "其他");
                     otherDept1.put("desc", "其他");
                     otherDept1.put("writeable", 0);
                     otherDept1.put("attributes", "");
            	 }else{
            		 otherDept.put("children", paraseData1(getToken(), getProduct(), getAppKey(),departmentUserTreeAppVo.getChildren(),departmentUserTreeAppVo.getName(),departmentUserTreeAppVo.getId(),userName));
                     otherDept.put("id",  departmentUserTreeAppVo.getId());
                     otherDept.put("key",  departmentUserTreeAppVo.getId());
                     otherDept.put("value", departmentUserTreeAppVo.getId());
                     otherDept.put("state", "open");
                     otherDept.put("type", "department");
                     otherDept.put("label", departmentUserTreeAppVo.getName());
                     otherDept.put("title", departmentUserTreeAppVo.getName());
                     otherDept.put("name", departmentUserTreeAppVo.getName());
                     otherDept.put("desc", null);
                     otherDept.put("writeable", 0);
                     otherDept.put("attributes", "");
                     content.add(otherDept);
           	 }

			}
             if(otherDept1!=null){
            	 content.add(otherDept1);
             }
              return CommonResponseUtil.success(content);
          } catch (Exception e) {
        	  e.printStackTrace();
              logger.error("通讯录异常", e);
              return CommonResponseUtil.failure("系统繁忙，请稍后再试");
          }



    }




    private  List<LinkedHashMap<String, Object>>  paraseData1(String toke, String product,String appKey, List<DepartmentUserTreeAppVo>  map,String name,String depid,String username ) {

    	  List<LinkedHashMap<String, Object>> content = new ArrayList<>();
    	  if(map!=null&&map.size()>0){
    	for (DepartmentUserTreeAppVo departmentUserTreeAppVo : map) {


    		      if("dept".equals(departmentUserTreeAppVo.getType())){
    		    	  LinkedHashMap<String, Object> otherDept = new LinkedHashMap<>();
    		    	  otherDept.put("children", paraseData1(getToken(), getProduct(), getAppKey(),departmentUserTreeAppVo.getChildren(),departmentUserTreeAppVo.getName(),departmentUserTreeAppVo.getId(),username));
                      otherDept.put("id",  departmentUserTreeAppVo.getId());
                      otherDept.put("key",  departmentUserTreeAppVo.getId());
                      otherDept.put("value", departmentUserTreeAppVo.getId());
                      otherDept.put("state", "open");
                      otherDept.put("type", "department");
                      otherDept.put("label", departmentUserTreeAppVo.getName());
                      otherDept.put("title", departmentUserTreeAppVo.getName());
                      otherDept.put("name", departmentUserTreeAppVo.getName());
                      otherDept.put("desc", null);
                      otherDept.put("writeable", 0);
                      otherDept.put("attributes", "");
                      content.add(otherDept);
    		      }else{
    		    	    LinkedHashMap<String, Object> user = new LinkedHashMap<>();
    	    	        user.put("id", departmentUserTreeAppVo.getId());
    	    	        user.put("key",departmentUserTreeAppVo.getId());
    	    	        user.put("value", departmentUserTreeAppVo.getId());
    	    	        user.put("checked", false);
    	    	        user.put("state", "open");
    	    	        user.put("type", "user");
    	    	        user.put("label", departmentUserTreeAppVo.getName());
    	    	        user.put("title", departmentUserTreeAppVo.getName());
    	    	        user.put("name", departmentUserTreeAppVo.getName());
    	    	        user.put("desc", null);
    	    	        user.put("writeable", 0);
    	    	        user.put("userName",departmentUserTreeAppVo.getName());
    	    	        user.put("depid", depid);
    	    	        //获取电话邮箱
                        Map<String,String> userObj = departmentUserTreeAppVo.getObject();
                        if (userObj != null && userObj.get("telephone") != null) {
                            user.put("mobile",userObj.get("telephone"));
                        } else {
                            user.put("mobile", "");
                        }
                        if (userObj != null && userObj.get("email") != null) {
                          user.put("email",userObj.get("email"));
                        } else {
                            user.put("email", "");
                        }
                      if (userObj != null && userObj.get("mobile") != null) {
                          user.put("mobile",userObj.get("mobile"));
                      } else {
                          user.put("mobile", "");
                      }
//    	    	        AgencyUserModel userdate=remoteSecurityService.getUserById( toke, product, appKey, departmentUserTreeAppVo.getId());
//    	    	        if(userdate!=null){
//    	    	          user.put("telephone", userdate.getLandlinePhone());
//    	    	          user.put("mobile", userdate.getMobile());
//    	    	    	  user.put("email", userdate.getEmail());
//    	    	        }else{
//                        user.put("mobile", "");
//    	    	        }
    	    	        user.put("departmentName",name);
    	    	        if(username!=null&&!"".equals(username)){
    	     			   if(!ObjectUtils.isEmpty(departmentUserTreeAppVo.getName()) && departmentUserTreeAppVo.getName().indexOf(username) != -1){
    	     				  content.add(user);
    	     			   }
    	     		   }else{
    	     			  content.add(user);
    	     		   }
    		      }
		}
    	  return content;
    	  }
    	  return null;
    }


    private List<LinkedHashMap<String, Object>> filterUser(List<LinkedHashMap<String, Object>> tempChildren,
                                                           String userNmae) {
        List<LinkedHashMap<String, Object>> userList = new ArrayList<LinkedHashMap<String, Object>>();
        if (ObjectUtils.isEmpty(tempChildren)) {
            return userList;
        }
        userList.forEach((item) -> {
            if (!ObjectUtils.isEmpty(userNmae) && item.get("label").toString().indexOf(userNmae) != -1) {
                userList.add(item);
            }
        });
        return userList;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "用户登录成功之后数据初始化(<font color='blue'>手机app</font>)", notes = "用户登录成功之后数据初始化")
    @RequestMapping(value = "/initData", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse initUserApp() {
    	 try {
             CommonResponse secResponse = remoteSecurityService.searchPermissionTree(getToken(), getProduct(), getAppKey(), appType);
             if (!secResponse.isSuccess()) {
                 return CommonResponseUtil.failure("权限获取失败");
             }
             List<LinkedHashMap<String, Object>> response = new ArrayList<>();
             HashMap<String, Object> resp = new HashMap<>();
             resp.put("permissionitems", secResponse.getDataList());
             resp.put("companys", response);
             return CommonResponseUtil.success(resp);
         } catch (Exception e) {
             return CommonResponseUtil.failure("数据初始化失败");
         }
    }

    /**
     * 递归调用获取list中的末端节点
     *
     * @param src
     * @return
     */
    private List<LinkedHashMap<String, Object>> getLeaves(List<LinkedHashMap<String, Object>> src) {
        List<LinkedHashMap<String, Object>> dest = new ArrayList<>();
        for (LinkedHashMap<String, Object> leaves : src) {
            if (ObjectUtils.isEmpty(leaves.get("children"))) {
                dest.add(leaves);
            } else {
                List<LinkedHashMap<String, Object>> list = getLeaves((List<LinkedHashMap<String, Object>>) leaves.get("children"));
                dest.addAll(list);
            }
        }
        return dest;
    }

    ///////////////////////////////2019-11-18安全服务升级///////////////////////////////
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "通讯录", notes = "通讯录")
    @RequestMapping(value = "/mobile/addressList", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse addressList() {
         try {
            ReginParams reginParams = getSelectedOrgInfo();
            CompanyBo companyBo = reginParams.getCompany();
            JSONArray arr = remoteSecurityService.listDepartmentUserTree(getToken(), getProduct(), getAppKey(), companyBo.getSequenceNbr().toString());
            DepartmentUserTreeAppVo departmentUserTreeDto = new DepartmentUserTreeAppVo();
            if (arr != null && arr.size() > 0) {
                buildUserDeptTree(departmentUserTreeDto, arr);
            }
            return CommonResponseUtil.success(departmentUserTreeDto.getChildren());
        } catch (Exception e) {
            logger.error("通讯录异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }


    }










    private void buildUserDeptTree(DepartmentUserTreeAppVo deptUser, JSONArray childs) {
        for (int i = 0; i < childs.size(); i++) {
            JSONObject json = childs.getJSONObject(i);
            DepartmentUserTreeAppVo treeDto = new DepartmentUserTreeAppVo();
            treeDto.setName(json.getString("departmentName"));
            treeDto.setId(json.getString("sequenceNbr"));
            treeDto.setType(json.getString("level"));
            JSONArray childrens = json.getJSONArray("children");
            if (childrens != null && childrens.size() > 0) {
                buildUserDeptTree(treeDto, childrens);
            }
            JSONArray userModelList = json.getJSONArray("userModelList");
            if(userModelList != null && userModelList.size() > 0){
                List<HashMap> modelList = JSONObject.parseArray(userModelList.toJSONString(), HashMap.class);
                modelList=modelList.stream().distinct().collect(Collectors.toList());
                userModelList= JSONArray.parseArray(JSON.toJSONString(modelList));
            	UserDeptTree( treeDto,  userModelList);
            }

          deptUser.getChildren().add(treeDto);
        }
    }
    //部门下用户

    private void UserDeptTree(DepartmentUserTreeAppVo deptUser, JSONArray childs) {

  	  for (int i = 0; i < childs.size(); i++) {
            JSONObject json = childs.getJSONObject(i);
            DepartmentUserTreeAppVo treeDto = new DepartmentUserTreeAppVo();
            treeDto.setName(json.getString("realName"));
            treeDto.setId(json.getString("userId"));
            //treeDto.setType(json.getString("level"));
            treeDto.setType("user");
	         // JSONObject object = json.getJSONObject("object");
	          Map<String, String> user = Maps.newHashMap();
	          user.put("mobile", json.getString("mobile"));
	          user.put("telephone", json.getString("landlinePhone"));
	          user.put("email", json.getString("email"));
	          treeDto.setObject(user);
            deptUser.getChildren().add(treeDto);
        }
    }

    /**
     * APP登录
     */
    @ApiOperation(value = "APP登录", notes = "APP登录")
    @PostMapping(value = "/mobile/login")
    public CommonResponse mobileLogin(@ApiParam(value = "账号", required = true) @RequestBody AppLoginUserParam param) {
        try {
 	       JSONObject jsonObject =null;
   		     IdPasswordAuthModel  dPasswordAuthModel=new IdPasswordAuthModel();
   	    	 dPasswordAuthModel.setLoginId(param.getUserName());
   	    	 dPasswordAuthModel.setPassword(DesUtil.decode(param.getPassword(), "yeejoin"));
    	         HttpHeaders headers = new HttpHeaders();
   	         headers.setContentType(MediaType.APPLICATION_JSON);
   	         headers.set("Content-Type", "application/json");
   	         headers.set("product", productApp);
   	         HttpEntity httpEntity = new HttpEntity<>(dPasswordAuthModel, headers);
   	         FeignClientResult feignClientResult = restTemplate.postForObject("http://"+SecurityName+"/privilege/v1/auth/idpassword",httpEntity, FeignClientResult.class);
   	  	 if (feignClientResult.getStatus() ==200 ) {
   			   Map  map = (Map) feignClientResult.getResult();
   	           map.put("appKey", appKey);
  			   map.put("product", productApp);
  			   String jsonStr = JSON.toJSONString(map);
 	           jsonObject = JSONObject.parseObject(jsonStr);
   			 }else{
   				 return CommonResponseUtil.failure(feignClientResult.getMessage());
   			 }
        if (jsonObject != null) {
           JSONObject result = new JSONObject();
           result.put("token", jsonObject.getString("token"));
           result.put("userId", jsonObject.getString("userId"));
           result.put("appKey", jsonObject.getString("appKey"));
           result.put("product", jsonObject.getString("product"));
           result.put("jpushUserKey", param.getUserName());
//           //删除别名关联设备
//           CommonResponse commonResponse=PushFeign.PushDevice(appMessagePushService.buildJpushUserKey(jsonObject.getString("userId")));
           return CommonResponseUtil.success(result);
       }
       return CommonResponseUtil.failure("登录失败");
   } catch (Exception e) {
       e.printStackTrace();
       logger.error("APP登录异常", e);
       return CommonResponseUtil.failure("系统繁忙，请稍后再试");
   }
    }

    /**
     * APP登出
     */

    @ApiOperation(value = "APP登出", notes = "APP登出")
    @PostMapping(value = "/mobile/loginOut")
    public CommonResponse mobileLoginOut() {
    	 try {
//             if (remoteSecurityService.loginOutFromApp(getToken(), getProduct(), getAppKey())) {
//                 return CommonResponseUtil.success();
//             } else {
//                 return CommonResponseUtil.failure("APP登出失败");
//             }
             return CommonResponseUtil.success();
         } catch (Exception e) {
             logger.error("APP登出异常", e);
             return CommonResponseUtil.failure("系统繁忙，请稍后再试");
         }
    }

    /**
     * 获取公司选择信息
     */
    @ApiOperation(value = "获取公司选择信息", notes = "获取公司选择信息")
    @GetMapping(value = "/selectInfo")
    public CommonResponse selectInfo() {
    	 try {
             JSONObject result = new JSONObject();
             AgencyUserModel user = getUserInfo();
             if (user != null) {
             	List<CompanyModel>  list  =user.getCompanys().stream().collect(
             	            Collectors.collectingAndThen(
             	                    Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(CompanyModel::getSequenceNbr))), ArrayList::new));

                 Map<Long, List<DepartmentModel>>  mapDepartments= user.getCompanyDepartments();
                 Map<String, List<Map<String, Object>>> mapdate=new HashMap<String, List<Map<String, Object>>>();

             	List<Map>  listCompanyModel =new ArrayList();
             	if(list!=null&&list.size()>0){
             	for (CompanyModel article : list) {
             		Map<String, Object>  map=   objectToMap(article);
             		map.put("companySeq", map.get("companySeq")+"");
             		map.put("parentId", map.get("parentId")+"");
             		listCompanyModel.add(map);

             		long key= Long.valueOf( map.get("sequenceNbr").toString());
             		 List<DepartmentModel> listdep=mapDepartments.get(key);
                  	 List<Map<String, Object>>  dep =new ArrayList();
                  	for (DepartmentModel departmentModel : listdep) {
                  		if(departmentModel!=null){
                 			Map<String, Object>  mapo=   objectToMap(departmentModel);
                    		mapo.put("sequenceNbr", mapo.get("sequenceNbr").toString());
                    		dep.add(mapo);
                 		}
                  	}

                  	mapdate.put(map.get("sequenceNbr").toString(), dep);
             	}
             	}
                 result.put("companys", listCompanyModel);
                 result.put("orgRoles", user.getOrgRoles());

                 result.put("companyDepartments", mapdate);
                 return CommonResponseUtil.success(result);
             }
             return CommonResponseUtil.failure("请重新登录");
         } catch (Exception e) {
             logger.error("获取公司选择信息异常", e);
             return CommonResponseUtil.failure("系统繁忙，请稍后再试");
         }
    }

    //对象转map
    public static Map<String, Object> objectToMap(Object obj) throws IllegalAccessException {
    	 Map<String, Object> map = new HashMap<String,Object>();
     	if(obj!=null){
         Class<?> clazz = obj.getClass();
         for (Field field : clazz.getDeclaredFields()) {
             field.setAccessible(true);
             String fieldName = field.getName();
             Object value = nvl(field.get(obj));
             map.put(fieldName, value);
         }
         return map;
     }
     return map;
    }
    public static Object nvl(Object param) {
        return param != null ? param : "";
    }
    /**
     * 保存登陆用户选择公司信息
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "保存登陆用户选择公司信息", notes = "保存登陆用户选择公司信息")
    @PostMapping(value = "/save/curCompany")
    public CommonResponse saveCurCompany(@ApiParam(value = "当前登陆用户所选单位机构编号", required = true) @RequestBody ReginParams reginParams) {
    	 try {
             AgencyUserModel user = getUserInfo();
             saveSelectedOrgInfo(reginParams);
             return CommonResponseUtil.success(buildCurCompany(getToken(),getProduct(),getAppKey(),reginParams, user));
         } catch (Exception e) {
             logger.error("保存登陆用户选择公司信息异常", e);
             return CommonResponseUtil.failure("系统繁忙，请稍后再试");
         }
    }

    private JSONObject buildCurCompany(String toke,String product,String appKey,ReginParams reginParams, AgencyUserModel user) {
        JSONObject result = new JSONObject();
        result.put("userId", user.getUserId());
        result.put("realName", user.getRealName());
        result.put("userMobile", user.getMobile());
        result.put("userName", user.getUserName());
        result.put("email", user.getEmail());
        CommonResponse secResponse = remoteSecurityService.searchPermissionTree(Long.valueOf(reginParams.getRole().getSequenceNbr()),toke,product,appKey,appType);
        if (secResponse.isSuccess() && secResponse.getDataList() != null) {
            JSONArray arr = JSON.parseArray(JSONArray.toJSONString(secResponse.getDataList()));
            Map<String, JSONObject> map = Maps.newHashMap();
            if (arr != null && arr.size() > 0) {
                JSONObject obj = arr.getJSONObject(0);
                if (obj != null) {
                    JSONArray childrens = obj.getJSONArray("children");
                    if (childrens != null && childrens.size() > 0) {
                        for (int i = 0; i < childrens.size(); i++) {
                            JSONObject child = childrens.getJSONObject(i);
                            map.put(child.getString("path"), child);
                        }
                    }
                }
                List<String> userHaveToDo = iAppService.getHaveToDoList(user.getUserId());
                result.put("userHaveToDo", userHaveToDo);
                result.put("userPower", map.get("appPower"));
                result.put("userShow", map.get("appMenu"));
            }
        }
        result.put("companyModel", reginParams.getCompany());
        result.put("departmentModel", reginParams.getDepartment());
        result.put("roleModel", reginParams.getRole());
        return result;
    }

    /**
     * 装备登录返回巡检统计信息
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "装备登录返回巡检统计信息", notes = "装备登录返回巡检统计信息")
    @GetMapping(value = "/patrolCount")
    public CommonResponse getPatrolCount() {
        try {
            AgencyUserModel user = getUserInfo();
            List<String> userHaveToDo = iAppService.getHaveToDoList(user.getUserId());
            return CommonResponseUtil.success(userHaveToDo);
        } catch (Exception e) {
            logger.error("保存登陆用户选择公司信息异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }

    /**
     * 修改密码
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = " 修改密码", notes = " 修改密码")
    @GetMapping(value = "/editPassword")
    public CommonResponse editPassword(@ApiParam(value = "旧密码", required = true) @RequestParam String password,
                                       @ApiParam(value = "新密码", required = true) @RequestParam String newPassword) {
   	 AgencyUserModel userModel = getUserInfo();
        boolean flag=false;
        if(password.equals(newPassword)){
       	 return CommonResponseUtil.failure("新密码不能跟旧密码相同！");
        }
        try {
        //flag=remoteSecurityService.editPassword(getToken(), getProduct(), getAppKey(), userModel.getUserId(), password, newPassword);
        	AgencyUserModel agencyUserModel=new AgencyUserModel();
            agencyUserModel.setPassword(newPassword);
            agencyUserModel.setRePassword(newPassword);
            agencyUserModel.setOriginalPassword(password);
			     HttpHeaders headers = new HttpHeaders();
		         headers.setContentType(MediaType.APPLICATION_JSON);
		         headers.set("Content-Type", "application/json");
		         headers.set("product", getProduct());
		         headers.set("token", getToken());
		         headers.set("appKey", getAppKey());
	         HttpEntity httpEntity = new HttpEntity<>(agencyUserModel, headers);
	      ResponseEntity<FeignClientResult> feignClientResult   =  restTemplate.exchange("http://"+SecurityName+"/privilege/v1/agencyuser/"+userModel.getUserId()+"/password", HttpMethod.PUT,httpEntity, FeignClientResult.class);
	  	 if (feignClientResult.getBody().getStatus() ==200 ) {
	  		CommonResponse dates =CommonResponseUtil.success();
	  		dates.setMessage("修改成功！");
	  	      return dates;
			 }else{
				 return CommonResponseUtil.failure(feignClientResult.getBody().getMessage());
			 }

    } catch (Exception e) {
        logger.error("修改密码异常", e);
        return CommonResponseUtil.failure(e.getMessage());
    }
        }
}
