package com.yeejoin.amos.boot.module.common.api.feign;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;

/**
 * 隐患服务feign
 *
 * @author Dell
 */
@FeignClient(name = "${latentDanger.feign.name:AMOS-LATENT-DANGER}", path = "latentDanger", configuration = {MultipartSupportConfig.class})
public interface LatentDangerFeignClient {

    /**
     * 获取未完成隐患数量
     *
     * @return
     */
    @RequestMapping(value = "/api/latent/danger/app/unFinished", method = RequestMethod.GET)
    ResponseModel<Object> getUnFinishedDangerCount();
    
    /**
     * 获取未完成隐患数量
     *
     * @return
     */
    @RequestMapping(value = "/api/latent/danger/app/currentLandgerCount", method = RequestMethod.GET)
    ResponseModel<Object> currentLandgerCount();

}
