package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.FailureDetailsDto;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrDto;
import com.yeejoin.amos.boot.module.common.api.dto.StatusDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureDetails;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2021-08-04
 */
public interface FailureDetailsMapper extends BaseMapper<FailureDetails> {

    /**
     * 查询全部 分页
     *
     * @param currentStatus 当前任务状态
     *                      * @param  startTime 起始时间
     *                      * @param endTime 结束时间
     *                      * @param submissionPid 报送人
     * @param current       当前页
     * @return
     */

    List<FailureDetails> selectAllPage(Long current, Long size, Long currentStatus,
                                       String startTime, String endTime, Integer submissionPid);

    List<FailureDetailsDto> selectWebPage(Long current, Long size,Long currentStatus,
                                       String startTime, String endTime, String submissionName, Long submissionBranchId,
                                       Long sequenceNbr);

    int selectAllCount();

    List<FailureDetails> queryForWaitManage(Long current, Long size, Long currentStatus,
                                            String startTime, String endTime, Integer submissionPid,String ruleName);

    /**
     * 统计  全部
     *
     * @param currentStatus 状态
     * @param startTime     起始时间
     * @param endTime       结束时间
     * @param submissionPid 报送人
     * @return
     */
    List<StatusDto> selectStatusCount(Long currentStatus, String startTime, String endTime, Integer submissionPid);
    List<StatusDto> queryStatusCount(Long currentStatus, String startTime, String endTime, Integer submissionPid,String ruleName);

    List<StatusDto> queryAcceptCount(Long currentStatus, String startTime, String endTime, Integer submissionPid, String userId,String ruleName);

    List<FailureDetails> selectForReceive(Long currentStatus, String startTime, String endTime, Integer submissionPid, String userId,Long current, Long size,String ruleName);

}
