package com.yeejoin.amos.boot.module.jcs.api.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.component.rule.Label;
import com.yeejoin.amos.component.rule.RuleFact;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * app消息web 消息推送 ----力量调派
 * 
 * @author Dell
 *
 */
@Data
@RuleFact(value = "警情消息", project = "消息规则")
public class PushMessageWebAndAppRo implements Serializable {
	
    /**
	 * 
	 */
	private static final long serialVersionUID = -8083389507633759711L;

	@Label(value = "类别")
    private Integer category;
	
	@Label("警情id--关联字段")
	private String relationId;
	/**
	 * 警情初报、力量调派等
	 */
	@Label("警情消息类型")
	private String msgType;

	@Label(value = "发送名称")
	private String name;

	@Label(value = "地址")
	private String address;

	@Label(value = "警情填报时间")
	private String startTime;

	@Label(value = "警情结案时间")
	private String endTime;

	@Label(value = "发送时间")
	private String sendTime;

	@Label(value = "发送单位")
	private String companyName;

	@Label(value = "被困人数")
	private String trappedNum;

	@Label(value = "伤亡人数")
	private String casualtiesNum;

	@Label(value = "火势情况")
	private String fireSituation;

	@Label(value = "货位转移")
	private String transferLocation;

	@Label(value = "接收人")
	private List<String> recivers;

	@ApiModelProperty(value = "终端标识")
	private String terminal;

	@Label(value = "发送到web标识")
	private Boolean isSendWeb;

	@Label(value = "发送到app标识")
	private Boolean isSendApp;

	@Label(value = "执行方法")
	private String ruleType;

	@ApiModelProperty(value = "消息类型")
	private Map<String, String> extras;
}
