package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.CommercialDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.CommercialServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 商务信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@RestController
@Api(tags = "商务信息Api")
@RequestMapping(value = "/commercial")
public class CommercialController extends BaseController {

    @Autowired
    CommercialServiceImpl commercialServiceImpl;

    /**
     * 新增商务信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增商务信息", notes = "新增商务信息")
	public ResponseModel<CommercialDto> save(@RequestBody CommercialDto model) {
	    model = commercialServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新商务信息", notes = "根据sequenceNbr更新商务信息")
	public ResponseModel<CommercialDto> updateBySequenceNbrCommercial(@RequestBody CommercialDto model,@ApiParam(value = "主键",example = "1805040753609568257")@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(commercialServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除商务信息", notes = "根据sequenceNbr删除商务信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @ApiParam(value = "主键",example = "1805040753609568257")@PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(commercialServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个商务信息",  notes = "根据sequenceNbr查询单个商务信息")
	public ResponseModel<CommercialDto> selectOne(@ApiParam(value = "主键",example = "1805040753609568257")@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(commercialServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "商务信息分页查询",  notes = "商务信息分页查询")
	public ResponseModel<Page<CommercialDto>> queryForPage(@ApiParam(value = "当前页码",example = "1")@RequestParam(value = "current") int current,@ApiParam(value = "分页条数",example = "20")@RequestParam
                    (value = "size") int size) {
	    Page<CommercialDto> page = new Page<CommercialDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(commercialServiceImpl.queryForCommercialPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "商务信息列表全部数据查询",   notes = "商务信息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CommercialDto>> selectForList() {
	    return ResponseHelper.buildResponse(commercialServiceImpl.queryForCommercialList());
	}
}
