package com.yeejoin.amos.boot.module.hygf.biz.excel.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Map;

@Getter
@AllArgsConstructor
public enum BusinessTypeEnum {
    BASIC_INFORMATION("基本信息"),
    SURVEY_INFORMATION("勘察信息"),
    DESIGN_INFORMATION("设计信息"),
    BUSINESS_INFORMATION("商务信息"),
    EXTENDED_INFORMATION("扩展信息"),
    ARCHIVING_INFORMATION("资料归档"),
    ENGINEERING_INFORMATION("工程信息"),
    GRID_INFORMATION("并网信息"),
    DISPATCH_ORDER_INFORMATION("派工单信息"),
    ;
    private String name;

    public static BusinessTypeEnum getEnumByName(String name) {
        for (BusinessTypeEnum businessTypeEnum : BusinessTypeEnum.values()) {
            if (businessTypeEnum.getName().equals(name)) {
                return businessTypeEnum;
            }
        }
        return null;
    }
}
