package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizFanHealthLevelDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanHealthLevel;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanHealthLevelMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IIdxBizFanHealthLevelService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-08-15
 */
@Service
public class IdxBizFanHealthLevelServiceImpl extends BaseService<IdxBizFanHealthLevelDto, IdxBizFanHealthLevel, IdxBizFanHealthLevelMapper> implements IIdxBizFanHealthLevelService {
    /**
     * 分页查询
     */
    public Page<IdxBizFanHealthLevelDto> queryForIdxBizFanHealthLevelPage(Page<IdxBizFanHealthLevelDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<IdxBizFanHealthLevelDto> queryForIdxBizFanHealthLevelList()   {
        return this.queryForList("" , false);
    }

    /**
     * 查询健康等级
     * @return
     */
    public JSONObject queryHealthLevel() {
        List<Map<String, Object>> maps = this.baseMapper.queryHealthLevel();
        JSONObject result = new JSONObject();
        result.put("colModel", buildColModel());
        result.put("dataGridMock", buildDataGridMock(maps));
        return result;
    }

    private JSONObject buildDataGridMock(List<Map<String, Object>> maps) {
        JSONObject result = new JSONObject();
        JSONArray dataList = new JSONArray();
        if (CollectionUtil.isNotEmpty(maps)) {
            result.put("total", maps.size());
            int i = 0;
            for (Map<String, Object> map : maps) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("_id", ++i);
                jsonObject.put("title2_measure", map.get("GROUP_UPPER_LIMIT"));
                jsonObject.put("title3_measure", map.get("GROUP_LOWER_LIMIT"));
                dataList.add(jsonObject);
            }
        }
        result.put("totalPage", 1);
        result.put("pageSize", 10);
        result.put("current", 1);
        result.put("pagination", false);
        result.put("dataList", dataList);
        return result;
    }

    private JSONArray buildColModel() {
        JSONArray result = new JSONArray();
        JSONObject dengji = new JSONObject();
        dengji.put("fid", "title1_measure");
        dengji.put("dataIndex", "title1_measure");
        dengji.put("name", "title1");
        dengji.put("title", "健康等级");
        dengji.put("type", "dataGrid");
        dengji.put("key", "title1_measure");
        JSONObject sx = new JSONObject();
        sx.put("fid", "title2_measure");
        sx.put("dataIndex", "title2_measure");
        sx.put("name", "title2");
        sx.put("title", "区间上限值");
        sx.put("type", "dataGrid");
        sx.put("key", "title2_measure");
        JSONObject xx = new JSONObject();
        xx.put("fid", "title3_measure");
        xx.put("dataIndex", "title3_measure");
        xx.put("name", "title3");
        xx.put("title", "区间下限值");
        xx.put("type", "dataGrid");
        xx.put("key", "title3_measure");
        result.add(dengji);
        result.add(sx);
        result.add(xx);
        return result;
    }

    public JSONArray queryPvSubArray() {
        List<Map<String, Object>> maps = this.baseMapper.queryPvSubArray();
        JSONArray result=new JSONArray();
        if(CollectionUtil.isNotEmpty(maps)){
            for (Map<String, Object> map : maps) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("text", map.get("SUBARRAY"));
                jsonObject.put("value", map.get("SUBARRAY"));
                result.add(jsonObject);
            }
        }
        return result;
    }
}