package com.yeejoin.amos.boot.module.jxiop.biz.config;


import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 * 从数据源配置
 * 若需要配置更多数据源 , 直接在yml中添加数据源配置再增加相应的新的数据源配置类即可
 */
@Configuration
@MapperScan(basePackages = "com.yeejoin.amos.boot.module.jxiop.biz.tdanalysismapper", sqlSessionFactoryRef = "taosAnalysisSqlSessionFactory")
public class TdEngineAnalysisConfig {
    private Logger logger = LoggerFactory.getLogger(TdEngineAnalysisConfig.class);
    // 精确到 cluster 目录，以便跟其他数据源隔离
    private static final String MAPPER_LOCATION = "classpath*:mapper/tdengineanalysis/*.xml";


    @Value("${spring.db4.datasource.url}")
    private String dbUrl;

    @Value("${spring.db4.datasource.username}")
    private String username;

    @Value("${spring.db4.datasource.password}")
    private String password;

    @Value("${spring.db4.datasource.driver-class-name}")
    private String driverClassName;


    @Bean(name = "taosAnalysisDataSource")   //声明其为Bean实例
    public DataSource clusterDataSource() {
        DruidDataSource datasource = new DruidDataSource();

        datasource.setUrl(this.dbUrl);
        datasource.setUsername(username);
        datasource.setPassword(password);
        datasource.setDriverClassName(driverClassName);
        return datasource;
    }

    @Bean(name = "taosAnalysisTransactionManager")
    public DataSourceTransactionManager clusterTransactionManager() {
        return new DataSourceTransactionManager(clusterDataSource());
    }

    @Bean(name = "taosAnalysisSqlSessionFactory")
    public SqlSessionFactory clusterSqlSessionFactory(@Qualifier("taosDataSource") DataSource culsterDataSource)
            throws Exception {
        final MybatisSqlSessionFactoryBean sessionFactory = new MybatisSqlSessionFactoryBean();
        sessionFactory.setDataSource(culsterDataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
                .getResources(TdEngineAnalysisConfig.MAPPER_LOCATION));
        sessionFactory.setTypeAliasesPackage("com.yeejoin.amos.boot.module.jxiop.biz.entity");
        //mybatis 数据库字段与实体类属性驼峰映射配置
        sessionFactory.getObject().getConfiguration().setMapUnderscoreToCamelCase(true);
        return sessionFactory.getObject();
    }
}

