package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.yeejoin.amos.boot.module.jxiop.api.dto.IndicatorDto;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.IndicatorServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.List;

import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * @author system_generator
 * @date 2023-06-08
 */
@RestController
@Api(tags = "图例卡片信息API")
@RequestMapping(value = "/indicator")
public class IndicatorController extends BaseController {

    @Autowired
    IndicatorServiceImpl indicatorServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增图例卡片信息", notes = "新增图例卡片信息")
    public ResponseModel<IndicatorDto> save(@RequestBody IndicatorDto model) {
        model = indicatorServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新图例卡片信息", notes = "根据sequenceNbr更新图例卡片信息")
    public ResponseModel<IndicatorDto> updateBySequenceNbrIndicator(@RequestBody IndicatorDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(indicatorServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除图例卡片信息", notes = "根据sequenceNbr删除图例卡片信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(indicatorServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个图例卡片信息", notes = "根据sequenceNbr查询单个图例卡片信息")
    public ResponseModel<IndicatorDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(indicatorServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询图例卡片信息", notes = "分页查询图例卡片信息")
    public ResponseModel<Page<IndicatorDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<IndicatorDto> page = new Page<IndicatorDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(indicatorServiceImpl.queryForIndicatorPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询图例卡片信息", notes = "列表全部数据查询图例卡片信息")
    @GetMapping(value = "/list")
    public ResponseModel<List<IndicatorDto>> selectForList() {
        return ResponseHelper.buildResponse(indicatorServiceImpl.queryForIndicatorList());
    }
}
