package com.yeejoin.amos.boot.module.jxiop.biz.jxdz.factory;

import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.Enum.JXDZDataTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

@Component
public class JXDZFactory {
    @Autowired
    private FDZJCServiceImpl fdzjcService;
    @Autowired
    private GFDZJCServiceImpl gfdzjcService;
    @Autowired
    private FDZSBJCServiceImpl fdzsbjcService;
    @Autowired
    private GFDZSBJCServiceImpl gfdzsbjcService;
    @Autowired
    private DZMTSJServiceImpl dzmtsjService;

    public IJXDZService getJXDZService(JXDZDataTypeEnum dataType) {
        switch (dataType) {
            case FDZJC:
                return fdzjcService;
            case GFDZJC:
                return gfdzjcService;
            case FDZSBJC:
                return fdzsbjcService;
            case GFDZSBJC:
                return gfdzsbjcService;
            case DZMTSJ:
                return dzmtsjService;
            default:
                throw new BadRequest("没有找到匹配的补录数据类型");
        }
    }

}
