package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 农户信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PeasantHouseholdDto", description="农户信息")
public class PeasantHouseholdDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "勘察表id")
    private Long surveyInformationId;

    @ApiModelProperty(value = "农户信息编号")
    private String peasantHouseholdNo;

    @ApiModelProperty(value = "业主姓名")
    private String ownersName;

    @ApiModelProperty(value = "联系电话")
    private String telephone;

    @ApiModelProperty(value = "开发方名称")
    @NotBlank(message = "开发方名称不能为空")
    private String developerName;

    @ApiModelProperty(value = "开发方code")
    @NotBlank(message = "开发方code不能为空")
    private String developerCode;


    @ApiModelProperty(value = "开发方平台id")
    @NotNull(message = "开发方平台id不能为空")
    private Long developerId;

    @ApiModelProperty(value = "定金")
    private Float deposit;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    @ApiModelProperty(value = "创建时间")
    private Date creationTime;

    @ApiModelProperty(value = "项目地址")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Integer> projectAddress;


    @ApiModelProperty(value = "常住是否相同")
    private String isPermanent;

    @ApiModelProperty(value = "常住地址")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Integer> permanentAddress;

    @ApiModelProperty(value = "是否勘察 0,1,2")
    private Integer surveyOrNot;

    @ApiModelProperty(value = "勘察状态描述")
    private String surveyOrNotText;

    @ApiModelProperty(value = "证件类型")
    private String idType;

    @ApiModelProperty(value = "身份证号")
    private String idCard;

    @ApiModelProperty(value = "邮箱")
    private String mailbox;

    @ApiModelProperty(value = " 审核状态 0未审核,1审核中，2审核结束")
    private Integer review;

    @ApiModelProperty(value = "项目详细地址")
    private String projectAddressDetail;

    @ApiModelProperty(value = "常住详细地址")
    private String permanentAddressDetail;

    @ApiModelProperty(value = "开发人")
    @NotBlank(message = "开发人不能为空")
    private String developer;
    @ApiModelProperty(value = "开发人userid")
    private String developerUserId;

    @ApiModelProperty(value = "常住地址")
    private String permanentAddressName;

    @ApiModelProperty(value = "项目地址")
    private String projectAddressName;

    @ApiModelProperty(value = "省市区文字集合")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<String> projectAddressText;

   @ApiModelProperty(value = "常住地址文字")
   @TableField(typeHandler = FastjsonTypeHandler.class)
   private List<String> permanentAddressText;

    @ApiModelProperty(value = "区域公司id")
    @NotNull(message = "区域公司id不能为空")
    private Long regionalCompaniesSeq;

    @ApiModelProperty(value = "区域公司code")
    @NotBlank(message = "区域公司code不能为空")
    private String regionalCompaniesCode;

    @ApiModelProperty(value = "区域公司名称")
    @NotBlank(message = "区域公司名称不能为空")
    private String regionalCompaniesName;

    @ApiModelProperty(value = "身份证正面")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    @NotEmpty(message = "身份证正面不能为空")
    private List<Object> idCardFront;

    @ApiModelProperty(value = "身份证反面")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    @NotEmpty(message = "身份证反面不能为空")
    private List<Object> idCardOpposite;

    @ApiModelProperty(value = "微信唯一id")
    private String openId;

    @ApiModelProperty(value = "是否已认证（0-未认证，1-已认证）")
    private Integer isCertified;

    @ApiModelProperty(value = "平台userId")
    private String amosUserId;
}
