package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 施工电站工程信息
 *
 * @author system_generator
 * @date 2024-01-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_power_station_engineering_info",autoResultMap = true)
public class PowerStationEngineeringInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 组件规格
     */
	@TableField("component_specification")
    private String componentSpecification;

    /**
     * 上网类型
     */
	@TableField("grid_connection_type")
    private String gridConnectionType;

    /**
     * 组件数量
     */
	@TableField("component_quantity")
    private Integer componentQuantity;

    /**
     * 逆变器数量
     */
	@TableField("inverter_quantity")
    private Integer inverterQuantity;

    /**
     * 并网箱数量
     */
	@TableField("grid_box_quantity")
    private Integer gridBoxQuantity;

    /**
     * 电缆规格
     */
	@TableField("cable_specification")
    private String cableSpecification;

    /**
     * 电站设计方案
     */
	@TableField("power_station_design_plan")
    private String powerStationDesignPlan;

    /**
     * 屋顶类型
     */
	@TableField("roof_type")
    private String roofType;

    /**
     * 组件类型
     */
	@TableField("component_type")
    private String componentType;

    /**
     * 并网箱类型
     */
	@TableField("grid_box_type")
    private String gridBoxType;

    /**
     * 并网箱功能
     */
	@TableField("grid_box_function")
    private String gridBoxFunction;

    /**
     * 
     */
	@TableField("work_order_id")
    private Long workOrderId;

    /**
     * 
     */
	@TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;


    @TableField("completion_date")
    private Date completionDate;




    /**
     * 施工组件信息
     */
    @TableField(exist = false)
    private List<Object> constructionComponentInfo;

    /**
     * 施工逆变器信息
     */
    @TableField(exist = false)
    private List<Object>  constructionInverterInfo;

    /**
     * 施工采集器信息
     */
    @TableField(exist = false)
    private List<Object> constructionCollectorBoxInfo;

    /**
     * 施工并网箱信息
     */
    @TableField(exist = false)
    private List<Object>  constructionGridBoxInfo;



    /**
     * 工程负责人
     */
    @TableField(exist = false)
    private String projectRegionManager;

    /**
     * 工程负责人电话
     */
    @TableField(exist = false)
    private String projectRegionManagerPhone;

    /**
     * 施工负责人
     */
    @TableField(exist = false)
    private String constructionRegionManager;

    /**
     * 施工负责人电话
     */
    @TableField(exist = false)
    private String constructionRegionManagerPhone;

}
