package com.yeejoin.amos.boot.module.hygf.biz.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.github.pagehelper.PageInterceptor;
import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpowerInterceptor;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;
import java.util.Properties;


/**
 * @description:
 * @author: tw
 * @createDate: 2023/9/19
 */
@Configuration
@MapperScan(basePackages = "com.yeejoin.amos.boot.module.hygf.api.tdenginemapper", sqlSessionTemplateRef = "tdengineSqlSessionTemplate")
public class TDengineServerConfig {

   @Value("${spring.datasource.tdengine-service.jdbc-url}")
   private String dbUrl;

   @Value("${spring.datasource.tdengine-service.username}")
   private String username;

   @Value("${spring.datasource.tdengine-service.password}")
   private String password;

   @Value("${spring.datasource.tdengine-service.driver-class-name}")
   private String driverClassName;
    @Value("${spring.datasource.tdengine-service.type}")
    private String dbType;
    private static final String MAPPER_LOCATION = "classpath*:mapper/tdengine/*.xml";


    @Bean(name = "tdengineDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.tdengine-service")
    public DataSource tdengineDataSource() {

//     DruidDataSource datasource = new DruidDataSource();
//     datasource.setUrl(this.dbUrl);
//     datasource.setUsername(username);
//     datasource.setPassword(password);
//     datasource.setDriverClassName(driverClassName);
//     datasource.setDbType(dbType);
//     return datasource;
       return DataSourceBuilder.create().build();
    }

    @Bean(name = "tdengineSqlSessionFactory")
    public SqlSessionFactory tdengineSqlSessionFactory(@Qualifier("tdengineDataSource") DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(MAPPER_LOCATION));

        //分页插件
        Interceptor interceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("helperDialect", "mysql");
        properties.setProperty("offsetAsPageNum", "true");
        properties.setProperty("rowBoundsWithCount", "true");
        properties.setProperty("reasonable", "true");
        properties.setProperty("supportMethodsArguments","true");
        properties.setProperty("params","pageNum=pageNum;pageSize=pageSize" +
                "" +
                ";");
        interceptor.setProperties(properties);



        bean.setPlugins(new Interceptor[] {interceptor,
                userEmpowerInterceptor(),
                paginationInterceptor()
        });
        return bean.getObject();

    }

    @Bean(name = "tdengineTransactionManager")
    public DataSourceTransactionManager tdengineTransactionManager(@Qualifier("tdengineDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public UserEmpowerInterceptor userEmpowerInterceptor() {
        UserEmpowerInterceptor userEmpowerInterceptor = new UserEmpowerInterceptor();

        return userEmpowerInterceptor;
    }

    @Bean(name = "tdengineSqlSessionTemplate")
    public SqlSessionTemplate tdengineSqlSessionTemplate(@Qualifier("tdengineSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        paginationInterceptor.setDialectType("mysql");
        return paginationInterceptor;
    }

}