package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.UserMessageDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.UserMessagePageDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.UserMessage;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.UserMessageServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 人员消息
 *
 * @author system_generator
 * @date 2023-09-12
 */
@RestController
@Api(tags = "人员消息Api")
@RequestMapping(value = "/user-message")
public class UserMessageController extends BaseController {

    @Autowired
    UserMessageServiceImpl userMessageServiceImpl;

    /**
     * 新增人员消息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增人员消息", notes = "新增人员消息")
	public ResponseModel<UserMessageDto> save(@RequestBody UserMessageDto model) {
	    model = userMessageServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新人员消息", notes = "根据sequenceNbr更新人员消息")
	public ResponseModel<UserMessageDto> updateBySequenceNbrUserMessage(@RequestBody UserMessageDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(userMessageServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除人员消息", notes = "根据sequenceNbr删除人员消息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(userMessageServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个人员消息",  notes = "根据sequenceNbr查询单个人员消息")
	public ResponseModel<UserMessageDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(userMessageServiceImpl.queryBySeq(sequenceNbr));
	}

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET",value = "人员任务分页查询",  notes = "人员任务分页查询")
    public ResponseModel<IPage<UserMessage>> queryForPage(UserMessagePageDto userMessagePageDto) {

        userMessagePageDto.setAmosUserId(getUserInfo().getUserId());
        return ResponseHelper.buildResponse(userMessageServiceImpl.queryUserMessagePageDto(userMessagePageDto));
    }

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "人员消息列表全部数据查询",   notes = "人员消息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<UserMessageDto>> selectForList() {
	    return ResponseHelper.buildResponse(userMessageServiceImpl.queryForUserMessageList());
	}



}
