package com.yeejoin.amos.boot.module.hygf.biz.feign;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.boot.module.hygf.api.dto.StandardDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.StartProcessDto;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


@FeignClient(name = "${workflow.feign.name:AMOS-API-WORKFLOW}", path = "workflow", configuration = {XidFeignConfiguration.class})
public interface WorkflowFeignClient {

    /***
     * 根据task_id 获取节点信息
     *
     * */
    @RequestMapping(value = "/history/task/nodeInfo", method = RequestMethod.GET)
    FeignClientResult<JSONObject> getNodeInfo(@RequestParam(value = "taskId") String taskId);


    /***
     *
     * 查询当前流程对应的可执行任务，无权限级别
     * */

    @RequestMapping(value = "/task/getTaskNoAuth/{processInstanceId}", method = RequestMethod.GET)
    JSONObject getTaskNoAuth(@PathVariable(value = "processInstanceId") String processInstanceId);

    /***
     *
     * 获取流程审批日志
     * */
    @RequestMapping(value = "/task/flowLogger/{procInsId}", method = RequestMethod.GET)
    FeignClientResult<Map<String,Object>> getFlowLogger(@PathVariable(value = "procInsId") String procInsId);



    @RequestMapping(value = "/history/task/nodeInfo", method = RequestMethod.GET)
    FeignClientResult<JSONObject> getNodeInfotoken(
            @RequestHeader(name="appKey",required = true) String appKey,
            @RequestHeader(name="product",required = true) String product,
            @RequestHeader(name="token",required = true) String token,
            @RequestParam(value = "taskId") String taskId);


    /***
     *
     * 查询当前流程对应的可执行任务，无权限级别
     * */

    @RequestMapping(value = "/task/getTaskNoAuth/{processInstanceId}", method = RequestMethod.GET)
    JSONObject getTaskNoAuthtoken(
                                    @RequestHeader(name="appKey",required = true) String appKey,
                                    @RequestHeader(name="product",required = true) String product,
                                    @RequestHeader(name="token",required = true) String token,
                                  @PathVariable(value = "processInstanceId") String processInstanceId);




    /**
     *
     * 发起流程
     *   {"businessKey": 业务id
     *   processDefinitionKey  ：hygf_bwys
     *   completeFirstTask：true}
     *是否需要自定执行第一个任务节点
     * */
    @RequestMapping(value = "/v2/task/start/batch", method = RequestMethod.POST)
    FeignClientResult<List<ProcessTaskDTO>> startProcess(@RequestBody StartProcessDto startProcessDto);

    @RequestMapping(value = "/v2/task/start/batch", method = RequestMethod.POST)
    FeignClientResult<List<ProcessTaskDTO>> startProcessnew(
            @RequestHeader(name="appKey",required = true) String appKey,
            @RequestHeader(name="product",required = true) String product,
            @RequestHeader(name="token",required = true) String token,
            @RequestBody StartProcessDto startProcessDto);

    /**
     * 执行流程
     *  {
     *
     *             "comment": 审核备注
     *             "result": 表达式值
     *             "resultCode": 表达式key,
     *             "taskId": "string",任务id
     *
     *             "variable": {
     *
     *            }
     *     }
     *
     * */
    @RequestMapping(value = "/v2/task/complete/standard/{taskId}", method = RequestMethod.POST)
    FeignClientResult<ProcessTaskDTO> standard( @PathVariable(value = "taskId") String taskId  ,@RequestBody StandardDto standardDto);




}