package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.hygf.api.dto.MaintenanceDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.Training;
import com.yeejoin.amos.boot.module.hygf.api.mapper.TrainingMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.ITrainingService;
import com.yeejoin.amos.boot.module.hygf.api.dto.TrainingDto;
import org.apache.ibatis.annotations.Param;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 培训信息表服务实现类
 *
 * @author system_generator
 * @date 2024-03-11
 */
@Service
public class TrainingServiceImpl extends BaseService<TrainingDto,Training,TrainingMapper> implements ITrainingService {
    /**
     * 分页查询
     */
    public Page<TrainingDto> queryForTrainingPage(Page<TrainingDto> page)   {


        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<TrainingDto> queryForTrainingList()   {
        return this.queryForList("" , false);
    }



    /**
     * 查询当前人培训资料学习状态
     * */
   public Page<TrainingDto> currentStudyStatusList(Integer current, Integer size, String status,
                                                   String name){



       Integer statusflag=null;
       if(status!=null&&status.equals("未学")){
           statusflag=0;
       }else if(status!=null&&status.equals("已学")){
           statusflag=1;
       }
        //查询当前人userId
       String exeUserId = RequestContext.getExeUserId();
        //通过userId查询对应运维人员培训表中的数据来区分是否学习
       PageHelper.startPage(current,  size);
       List<TrainingDto> resultPage= this.getBaseMapper().currentStudyStatusList(current,size,exeUserId,statusflag,name);
       PageInfo<TrainingDto> page = new PageInfo(resultPage);
       Page<TrainingDto> pagenew = new Page<TrainingDto>();
       pagenew.setCurrent(current);
       pagenew.setTotal(page.getTotal());
       pagenew.setSize(size);
       pagenew.setRecords(page.getList());


      return pagenew;
   }
}