package com.yeejoin.amos.boot.module.jxiop.biz.Thread;

import com.yeejoin.amos.boot.module.jxiop.biz.Enum.SmartAnalyseEnum;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.CommonServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;

public class MyServiceThread extends Thread {
    Logger logger = LoggerFactory.getLogger(MyServiceThread.class);
    private String startTime;
    private String endTime;
    private CommonServiceImpl commonService;
    private String type;


    public MyServiceThread(CommonServiceImpl commonService, String startTime, String endTime, String type) {
        this.commonService = commonService;
        this.startTime = startTime;
        this.endTime = endTime;
        this.type = type;
    }

    @Override
    public void run() {
        if (type.equals(SmartAnalyseEnum.FAN_QJHF.getKey())) {
            this.commonService.getFanConditionVariablesByTime(this.startTime, this.endTime);
            logger.info("--------------------------开始通过线程调用风机区间划分算法-----------------------");
        } else if (type.equals(SmartAnalyseEnum.FAN_XGX.getKey())) {
           this.commonService.getFanConditionVariablesByTimeAnalyse(startTime, endTime);
            logger.info("--------------------------开始通过线程调用风机相关性算法-----------------------");
        } else if (type.equals(SmartAnalyseEnum.FAN_ZXZ.getKey())) {
            this.commonService.getFanConditionVariablesByTimeAnalyse1(startTime, endTime);
            logger.info("--------------------------开始通过线程调用风机中心值算法-----------------------");
        } else if (type.equals(SmartAnalyseEnum.PV_QJHF.getKey())) {
            this.commonService.getPvConditionVariablesByTime(startTime, endTime);
            logger.info("--------------------------开始通过线程调用光伏区间划分算法-----------------------");
        } else if (type.equals(SmartAnalyseEnum.PV_XGX.getKey())) {
            this.commonService.getPvConditionVariablesByTimeAnalyse(startTime, endTime);
            logger.info("--------------------------开始通过线程调用光伏相关性算法-----------------------");
        } else if (type.equals(SmartAnalyseEnum.PV_ZXZ.getKey())) {
            this.commonService.getPvConditionVariablesByTimeAnalyse1(startTime, endTime);
            logger.info("--------------------------开始通过线程调用光伏中心值算法-----------------------");        }
    }
}
