package com.yeejoin.amos.boot.module.jxiop.api.feign;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

//@FeignClient(name = "${mcb.warning.name:MCB-SERVER}", path = "warning", configuration = {FeignConfiguration.class})
@FeignClient(name = "mcb", url = "http://10.20.1.160:10005", path = "core", configuration = {
        FeignConfiguration.class})
public interface CoreFeignClient {


    /**
     * @param stationNames
     * @param pointNames
     * @return
     * @Description 根据场站名称及测点名称获取合成测点值
     */
    @GetMapping("/scene-device-info/getValues")
    FeignClientResult<List<Object>> getValues(
            @RequestParam(required = false, value = "stationNames") String stationNames,
            @RequestParam(required = false, value = "pointNames") String pointNames);

    /**
     * @param stationName
     * @param filterNames
     * @param pointName
     * @return
     * @Description 根据场站名称及测点名称获取单个测点值
     */
    @GetMapping("/scene-device-info/getPointValue")
    FeignClientResult<Object> getPointValue(
            @RequestParam(required = false, value = "stationName") String stationName,
            @RequestParam(required = false, value = "filterNames") String filterNames,
            @RequestParam(required = false, value = "pointName") String pointName);
}
