package com.yeejoin.amos.boot.module.jxiop.biz.tdanalysismapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IndicatorData;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IndicatorDataNewMapper extends BaseMapper<IndicatorData> {


    @Select("select LAST(address)address,LAST(gateway_id)gatewayId,LAST(data_type)dataType,LAST(equipment_index_name)equipmentIndexName,LAST(`value_f`)valueF,LAST(equipment_number)equipmentNumber,LAST(created_time)createdTime from iot_data.indicator_data where equipment_index_name =#{equipmentIndexName}  and    gateway_id =#{gatewayId} and  ts >=#{startTime} and ts <=#{endTime}    group by address ")
    List<IndicatorData> selectlastfd(@Param("equipmentIndexName") String equipmentIndexName,@Param("gatewayId") String gatewayId,@Param("startTime") String startTime, @Param("endTime") String endTime);

    @Select("select LAST(address)address,LAST(gateway_id)gatewayId,LAST(data_type)dataType,LAST(equipment_index_name)equipmentIndexName,LAST(`value_f`)valueF,LAST(equipment_number)equipmentNumber,LAST(created_time)createdTime from iot_data.indicator_data where   equipment_index_name =#{equipmentIndexName}  and    gateway_id =#{gatewayId} and  ts >=#{startTime} and ts <=#{endTime}    group by address ")
    List<IndicatorData> selectlastgf(@Param("equipmentIndexName") String equipmentIndexName,@Param("gatewayId") String gatewayId,@Param("startTime") String startTime, @Param("endTime") String endTime);


    @Select("select  created_time createdTime, `value_f` as valueF from iot_data.indicator_data where equipment_index_name =#{equipmentIndexName}  and  ts >= #{startTime} and ts <= #{endTime} and gateway_id =#{gatewayId}")
    List<IndicatorData> selectDataByequipmentIndexNameAndtime(@Param("equipmentIndexName") String equipmentIndexName, @Param("startTime") String startTime, @Param("endTime") String endTime, @Param("gatewayId") String gatewayId);

    @Select("select sum(valueFs) valueF,xtime  from (select  SUBSTR(`created_time`, 11,6) xtime, `value_f` as valueFs  from iot_data.indicator_data  where equipment_index_name =#{equipmentIndexName}  and  ts >= #{startTime} and ts <= #{endTime} and gateway_id in (#{gatewayId})) group  by  xtime  order by xtime   ")
    List<IndicatorData> selectDataByequipmentIndexNameAndtimeqg(@Param("equipmentIndexName") String equipmentIndexName, @Param("startTime") String startTime, @Param("endTime") String endTime, @Param("gatewayId") String gatewayId);

    @Select("select `value`, created_time, `value_f` as valueF from iot_data.indicator_data where point_name =#{pointName} and  ts >= TODAY()-8h and point_type ='SYNTHETIC'")
    List<IndicatorData> selectDataByequipmentIndexNameAndtimeqgNew(@Param("equipmentIndexName") String pointName);

    @Select("select `value`, created_time, `value_f` as valueF from iot_data.indicator_data where point_name =#{pointName} and  ts >= TODAY()-8h and gateway_id in (#{gatewayId})) and point_type ='SYNTHETIC'")
    List<IndicatorData> selectDataByequipmentIndexNameAndtimeqgNew(@Param("equipmentIndexName") String pointName,@Param("gatewayId") String gatewayId);


    @Select("select `value`, created_time, `value_f` as valueF from iot_data.indicator_data where equipment_index_name =#{equipmentIndexName} and equipment_number = #{equipmentNumber} and  ts >= #{startTime} and ts <= #{endTime} and gateway_id = #{gatewayId}")
    List<IndicatorData> selectDataByequipmentIndexNameAndtimeAndEquipmentNumber(@Param("equipmentIndexName") String equipmentIndexName, @Param("equipmentNumber") String equipmentNumber, @Param("startTime") String startTime, @Param("endTime") String endTime, @Param("gatewayId") String gatewayId);

    @Select("select `value`, created_time, `value_f` as valueF, equipment_index_name from iot_data.indicator_data where equipment_index_name like '%路电流%' and equipment_number = #{equipmentNumber} and  ts >= #{startTime} and ts <= #{endTime} and gateway_id =#{gatewayId}")
    List<IndicatorData> selectDataByequipmentIndexNameAndtimeAndEquipmentNumberPv(@Param("equipmentNumber") String equipmentNumber, @Param("startTime") String startTime, @Param("endTime") String endTime, @Param("gatewayId") String gatewayId);



}
