package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.api.dto.HouseholdPvDistrictDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.HouseholdPvDistrict;
import com.yeejoin.amos.boot.module.jxiop.api.service.IHouseholdPvDistrictService;
import com.yeejoin.amos.boot.module.jxiop.api.util.CommonResponse;
import com.yeejoin.amos.boot.module.jxiop.api.util.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.HouseholdPvDistrictServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2023-03-17
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/household-pv-district")
public class HouseholdPvDistrictController extends BaseController {

    @Autowired
    HouseholdPvDistrictServiceImpl householdPvDistrictServiceImpl;

    @Autowired
    IHouseholdPvDistrictService householdPvDistrictService;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<HouseholdPvDistrictDto> save(@RequestBody HouseholdPvDistrictDto model) {
        model = householdPvDistrictServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<HouseholdPvDistrictDto> updateBySequenceNbrHouseholdPvDistrict(@RequestBody HouseholdPvDistrictDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(householdPvDistrictServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(householdPvDistrictServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<HouseholdPvDistrictDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(householdPvDistrictServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<HouseholdPvDistrictDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<HouseholdPvDistrictDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(householdPvDistrictServiceImpl.queryForHouseholdPvDistrictPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<HouseholdPvDistrictDto>> selectForList() {
        return ResponseHelper.buildResponse(householdPvDistrictServiceImpl.queryForHouseholdPvDistrictList());
    }


    @GetMapping(value = "/getTree")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "全量厂站树", notes = "全量厂站树")
    public ResponseModel<Object> getTree() {
        return ResponseHelper.buildResponse(householdPvDistrictService.getTree());
    }


    @GetMapping(value = "/getBusinessTree")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "厂站树", notes = "厂站树")
    public ResponseModel<Object> getBusinessTree(@RequestParam("platformCompanyId") Long parentId) {
        return ResponseHelper.buildResponse(householdPvDistrictService.getBusinessTree(parentId));
    }

    @GetMapping(value = "/stationTree")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "厂站树", notes = "厂站树")
    public ResponseModel<Object> stationTree() {
        return ResponseHelper.buildResponse(householdPvDistrictService.stationTree());
    }

    /**
     * 树节点新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/treeAdd")
    @ApiOperation(httpMethod = "POST", value = "树节点新增", notes = "树节点新增")
    public CommonResponse treeAdd(@RequestBody JSONObject model) {
        Map<String, Object> dto = (Map<String, Object>)model.get("dto");
        String id = dto.get("id").toString();
        String name = dto.get("name").toString();
        LambdaQueryWrapper<HouseholdPvDistrict> lambda = new QueryWrapper<HouseholdPvDistrict>().lambda();
        lambda.eq(HouseholdPvDistrict :: getName, name);
       // lambda.eq(HouseholdPvDistrict::getParentId, id);
        Integer integer = householdPvDistrictService.getBaseMapper().selectCount(lambda);
        if (integer > 0){
            return CommonResponseUtil.failure("节点已存在！");
        }
        return CommonResponseUtil.success(householdPvDistrictService.treeAdd(Long.parseLong(id), name));
    }

    /**
     * 树节点新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/treeUpdate")
    @ApiOperation(httpMethod = "POST", value = "树节点新增", notes = "树节点新增")
    public CommonResponse treeUpdate(@RequestBody JSONObject model) {
        Map<String, Object> dto = (Map<String, Object>)model.get("dto");
        String id = dto.get("id").toString();
        String name = dto.get("name").toString();
       // HouseholdPvDistrict householdPvDistrict = householdPvDistrictService.getBaseMapper().selectById(id);
        LambdaQueryWrapper<HouseholdPvDistrict> lambda = new QueryWrapper<HouseholdPvDistrict>().lambda();
        lambda.eq(HouseholdPvDistrict :: getName, name);
       // lambda.eq(HouseholdPvDistrict::getParentId, householdPvDistrict.getParentId());
        lambda.ne(HouseholdPvDistrict :: getSequenceNbr, id);
        Integer integer = householdPvDistrictService.getBaseMapper().selectCount(lambda);
        if (integer > 0){
            return CommonResponseUtil.failure("节点已存在！");
        }
        return CommonResponseUtil.success(householdPvDistrictService.treeUpdate(Long.parseLong(id), name));
    }
    /**
     * 树节点删除
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/treeNodesRemove")
    @ApiOperation(httpMethod = "DELETE", value = "树节点删除", notes = "树节点删除")
    public CommonResponse treeNodesRemove(@RequestParam("id") String id) {
        String result = householdPvDistrictService.treeNodesRemove(Long.parseLong(id));
        if (!"ok".equals(result)) {
            return CommonResponseUtil.failure(result);
        }
        return CommonResponseUtil.success(result);
    }
}
