package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jxiop.api.dto.IndicatorDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.Indicator;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.IndicatorMapper;
import com.yeejoin.amos.boot.module.jxiop.api.service.IIndicatorService;

import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-06-08
 */
@Service
public class IndicatorServiceImpl extends BaseService<IndicatorDto, Indicator, IndicatorMapper> implements IIndicatorService {

    /**
     * 分页查询
     */
    public Page<IndicatorDto> queryForIndicatorPage(Page<IndicatorDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<IndicatorDto> queryForIndicatorList()   {
        return this.queryForList("" , false);
    }


    @Override
    public List<Indicator> getIndicatorByType(String type) {
        QueryWrapper<Indicator> queryWrapper  = new QueryWrapper();
        queryWrapper.eq("type",type);
        List<Indicator>  indicatorDtoList  =this.list(queryWrapper);
        return indicatorDtoList;
    }
}