package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jxiop.api.amosprojectmapper.UserEmpowerMapper;
import com.yeejoin.amos.boot.module.jxiop.api.entity.MapRegion;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StdUserEmpower;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MapRegionMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.context.ThemeSource;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.Map;

@Service
public class JxiopMonitorMapPermissionServiceImpl {

    private UserEmpowerMapper userEmpowerMapper;
    private StationBasicMapper stationBasicMapper;
    private MapRegionMapper mapRegionMapper;

    @Autowired
    public JxiopMonitorMapPermissionServiceImpl(UserEmpowerMapper userEmpowerMapper,StationBasicMapper stationBasicMapper,MapRegionMapper mapRegionMapper) {
        this.userEmpowerMapper = userEmpowerMapper;
        this.stationBasicMapper  = stationBasicMapper;
        this.mapRegionMapper = mapRegionMapper;
    }

    public HashMap<String, Object> getShowPageType(ReginParams reginParams) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String userId = reginParams.getUserModel().getUserId();
        result.put("showType", "error");
        StdUserEmpower stdUserEmpower = userEmpowerMapper.selectOne(new QueryWrapper<StdUserEmpower>().eq("amos_user_id", userId).eq("permission_type", "YTH"));
        if (ObjectUtils.isEmpty(stdUserEmpower)) {
            result.put("errorMessage", "您当前未配置数据权限！");
            return result;
        } else {
            String permissionOrgCode = stdUserEmpower.getAmosOrgCode().get(0);
            Map<String,String>  companyInfo= userEmpowerMapper.getCompanyInfoByOrgCode(permissionOrgCode);
            String companyLevel = companyInfo.get("level").toString();
            if (companyLevel.equals("categroy_leve2")) {
                result.put("showType", "all");
                return result;
            }
            if(companyLevel.equals("area")){
                result.put("showType","area");
                String areaName =companyInfo.get("companyName").replace("片区","").replace("区域","");
                result.put("areaName",areaName);
                MapRegion mapRegion = mapRegionMapper.selectOne(new QueryWrapper<MapRegion>().eq("name",areaName));
                if(!ObjectUtils.isEmpty(mapRegion)){
                    result.put("proviceList",mapRegion.getJxiopProvince());
                }
                return result;
            }
            if(companyLevel.equals("station")){
                result.put("showType","station");
                StationBasic stationBasic = stationBasicMapper.selectOne(new QueryWrapper<StationBasic>().eq("project_org_code",permissionOrgCode));
                if(!ObjectUtils.isEmpty(stationBasic)){
                    result.put("stationId",stationBasic.getSequenceNbr());
                }
                return result;
            }
        }
        return result;
    }
}
