package com.yeejoin.equip.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author LiuLin
 * @date 2023年07月12日 18:11
 */
public class ExecutorFactory {

    private static final Integer DEFAULT_THREAD_NUM = Runtime.getRuntime().availableProcessors();
    private static final Integer THREAD_NUM_BIZ = DEFAULT_THREAD_NUM * 2;

    public static Executor buildBizExecutor() {
        return new ThreadPoolExecutor(
                THREAD_NUM_BIZ,
                THREAD_NUM_BIZ * 2,
                0L,
                TimeUnit.MILLISECONDS,
                new LinkedBlockingDeque<>(1024),
                new ThreadFactoryBuilder().setNameFormat("mqtt-pool-%d").build()
        );
    }
}
