package com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 电站基本信息
 * <p>
 * ProjectName: amos-boot-zx-biz
 * PackageName: com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine
 *
 * @author yangyang
 * @version v1.0
 * @date 2024/7/15 16:05
 */
@NoArgsConstructor
@Data
@TableName (value = "tanyin_station_info", autoResultMap = true)
public class TanYinStationInfo {

    @ApiModelProperty ("项目编号")
    @TableField ("project_no")
    private String projectNo;

    @ApiModelProperty ("姓名")
    @TableField ("customer_name")
    private String customerName;

    @ApiModelProperty ("手机号")
    @TableField ("customer_phone")
    private String customerPhone;

    @ApiModelProperty ("身份证")
    @TableField ("customer_id_no")
    private String customerIdNo;

    @ApiModelProperty ("省")
    @TableField ("province")
    private String province;

    @ApiModelProperty ("市")
    @TableField ("city")
    private String city;

    @ApiModelProperty ("区")
    @TableField ("area")
    private String area;

    @ApiModelProperty ("镇 + 详细地址")
    @TableField ("complete_address")
    private String completeAddress;

    @TableField (value = "inverterList",exist = false)
    private List<InverterListDTO> inverterList;

    @ApiModelProperty ("装机容量")
    @TableField ("capacity_size")
    private String capacitySize;

    @ApiModelProperty ("累计总发电量")
    @TableField ("total_power")
    private String totalPower;

    @ApiModelProperty ("当年发电量")
    @TableField ("year_power")
    private String yearPower;

    @ApiModelProperty ("当月发电量")
    @TableField ("month_power")
    private String monthPower;

    @ApiModelProperty ("当日发电量")
    @TableField ("day_power")
    private String dayPower;

    @ApiModelProperty ("纬度")
    @TableField ("latitude")
    private String latitude;

    @ApiModelProperty ("经度")
    @TableField ("longitude")
    private String longitude;

    @TableField ("create_time")
    private Long createTime;

    @NoArgsConstructor
    @Data
    public static class InverterListDTO {

        private String deviceName;

        private Integer supplier;

        private String sn;
    }
}
