package com.yeejoin.amos.api.householdapi.face.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import cn.hutool.core.collection.CollectionUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.api.householdapi.Utils.SofarRequestUtil;
import com.yeejoin.amos.api.householdapi.constant.SoFarConstant;
import com.yeejoin.amos.api.householdapi.face.dto.SofarInverterDto;
import com.yeejoin.amos.api.householdapi.face.dto.SofarWarm;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpCollector;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpInverter;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpInverterElectricity;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpStation;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.HYGFJPDayPower;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.HYGFJPInverterWarn;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.HYGFJPStationPowerHistory;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.SofarInverter;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.SofarStationList;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.TdHYGFInverterDayGenerate;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.TdHYGFInverterMonthGenerate;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.TdHYGFInverterTotalGenerate;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.TdHYGFInverterYearGenerate;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.TdHYGFStationMonthGenerate;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.TdHYGFStationYearGenerate;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.TdHYGFStationAllGenerate;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpCollectorMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpInverterElectricityMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpInverterMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpStationMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.HYGFJPCollectorHistoryMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.HYGFJPDayPowerMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.HYGFJPInverterWarnMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.HYGFJPStationPowerHistoryMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.SofarStationListMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.TdHYGFInverterDayGenerateMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.TdHYGFInverterMonthGenerateMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.TdHYGFInverterTotalGenerateMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.TdHYGFInverterYearGenerateMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.TdHYGFStationMonthGenerateMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.TdHYGFStationYearGenerateMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.TdHYGFStationAllGenerateMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.TdJpStationMapper;
import com.yeejoin.amos.api.householdapi.face.service.SofarDataAcquisitionService;
import com.yeejoin.amos.openapi.enums.PVProducerInfoEnum;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import fastjson.JSON;

@Service
@Slf4j
public class SofarDataAcquisitionServiceImpl implements SofarDataAcquisitionService {
	@Autowired
	private SofarRequestUtil requestUtil;

	@Autowired
	private JpInverterMapper jpInverterMapper;
	@Autowired
	SofarStationListMapper sofarStationListMapper;
	@Autowired
	private TdHYGFInverterDayGenerateMapper tdHYGFInverterDayGenerateMapper;
	@Autowired
	private TdHYGFInverterMonthGenerateMapper tdHYGFInverterMonthGenerateMapper;
	@Autowired
	private TdHYGFInverterYearGenerateMapper tdHYGFInverterYearGenerateMapper;
	@Autowired
	private TdHYGFStationMonthGenerateMapper TdHYGFStationMonthGenerateMapper;
	@Autowired
	private TdHYGFStationYearGenerateMapper TdHYGFStationYearGenerateMapper;
	@Autowired
	private TdHYGFStationAllGenerateMapper TdHYGFStationAllGenerateMapper;
	@Autowired
	private TdHYGFInverterTotalGenerateMapper tdHYGFInverterTotalGenerateMapper;
	@Autowired
	private JpInverterElectricityMapper jpInverterElectricityMapper;
	// 户用光伏逆变器告警
	@Autowired
	private HYGFJPInverterWarnMapper hygfjpInverterWarnMapper;
	@Autowired
	private JpStationMapper jpStationMapper;
	@Autowired
	private HYGFJPCollectorHistoryMapper hygfjpCollectorHistoryMapper;

	@Autowired
	private JpCollectorMapper jpCollectorMapper;
	@Autowired
	TdJpStationMapper tdJpStationMapper;
	@Autowired
	private HYGFJPStationPowerHistoryMapper hygfjpStationPowerHistoryMapper;
	@Autowired
	private HYGFJPDayPowerMapper hygfjpDayPowerMapper;

	@Override
	@Scheduled(cron = "${dataRequstScheduled.Sofar}")
	public void stationList() {
		Map<String, Object> requestInfo = new HashMap<>();
		requestInfo.put("page", 1);
		requestInfo.put("size", 1000);
		List<SofarStationList> jsonObject = requestUtil.getResPonseList(SoFarConstant.stationListUrl,
				SoFarConstant.requestPost, requestInfo, SoFarConstant.resovleRule_data, SofarStationList.class);
		// 新增td电站
		for (SofarStationList sunlight : jsonObject) {
			sunlight.setCreatedTime(System.currentTimeMillis());
			sofarStationListMapper.insert(sunlight);
		}
		//删除多余的信息
		deleteSHMessage(jsonObject);
		// mysql电站信息
		this.stationDetail(jsonObject);
	}

	/**
	 * 删除多余的首航场站
	 * @param sofarStationLists
	 */
	private void deleteSHMessage(List<SofarStationList> sofarStationLists) {
		if(CollectionUtil.isNotEmpty(sofarStationLists)){
			List<String> stationIds = new ArrayList<>();
			for (SofarStationList sofarStationList : sofarStationLists) {
				stationIds.add(sofarStationList.getId().toString());
			}
			//场站
			QueryWrapper<JpStation> wrapper = new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.SH.getCode());
			List<JpStation> jpStations = jpStationMapper.selectList(wrapper);
			if(CollectionUtil.isNotEmpty(jpStations)){
				for (JpStation jpStation : jpStations) {
					if(!stationIds.contains(jpStation.getThirdStationId())){
						//删除多余数据
						jpStationMapper.deleteById(jpStation.getSequenceNbr());
					}
				}
			}
			//采集器
			QueryWrapper<JpCollector> wrapper1 = new QueryWrapper<JpCollector>().eq("third_code", PVProducerInfoEnum.SH.getCode());
			List<JpCollector> jpCollectors = jpCollectorMapper.selectList(wrapper1);
			if(CollectionUtil.isNotEmpty(jpCollectors)){
				for (JpCollector jpCollector : jpCollectors) {
					if(!stationIds.contains(jpCollector.getThirdStationId())){
						//删除多余数据
						jpCollectorMapper.deleteById(jpCollector.getSequenceNbr());
					}
				}
			}
			//逆变器
			QueryWrapper<JpInverter> wrapper2 = new QueryWrapper<JpInverter>().eq("third_code", PVProducerInfoEnum.SH.getCode());
			List<JpInverter> jpInverters = jpInverterMapper.selectList(wrapper2);
			if(CollectionUtil.isNotEmpty(jpInverters)){
				for (JpInverter jpInverter : jpInverters) {
					if(!stationIds.contains(jpInverter.getThirdStationId())){
						//删除多余数据
						jpInverterMapper.deleteById(jpInverter.getSequenceNbr());
					}
				}
			}
		}
	}

	@Override
	public void stationDetail(List<SofarStationList> list) {

		// 业务表场站
		List<JpStation> jpStations = jpStationMapper
				.selectList(new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.SH.getCode()));

		Map<String, JpStation> bodyparam = new HashMap<>();

		if (jpStations != null && jpStations.size() > 0) {
			for (JpStation jpStation : jpStations) {
				bodyparam.put(jpStation.getThirdStationId(), jpStation);
			}
		}

		// 封装电站数据
		for (int i = 0; i < list.size(); i++) {
			SofarStationList sunlightDto = list.get(i);

			// System.out.println(i+"====================================================");
			JpStation jpStation = null;

			if (bodyparam.containsKey(sunlightDto.getId().toString())) {
				jpStation = bodyparam.get(sunlightDto.getId().toString());
			} else {
				jpStation = new JpStation();
			}

			jpStation.setThirdStationId(sunlightDto.getId().toString());
			jpStation.setName(sunlightDto.getName());
			jpStation.setAddress(sunlightDto.getLocationAddress());
			if(sunlightDto.getLocationLng() != null) 
			{
				BigDecimal bd = new BigDecimal(sunlightDto.getLocationLng());
				bd = bd.setScale(6, RoundingMode.DOWN);
				double truncatedNumber = bd.doubleValue();
				jpStation.setLongitude(String.valueOf(truncatedNumber));	
			}
			if(sunlightDto.getLocationLat() != null ) 
			{
				BigDecimal bd = new BigDecimal(sunlightDto.getLocationLat());
				bd = bd.setScale(6, RoundingMode.DOWN);
				double truncatedNumber = bd.doubleValue();
				jpStation.setLatitude(String.valueOf(truncatedNumber));	
			}
			jpStation.setThirdCode(PVProducerInfoEnum.SH.getCode());
			// 并网类型
			jpStation.setOnGridType(SofarRequestUtil.intoNetWorkStatus.get(sunlightDto.getGridInterconnectionType()));
			// 第三方厂商标识
			// jpStation.setThirdCode(PVProducerInfoEnum.YG.getCode());
			jpStation.setRecDate(new Date());

			// 获取单个电站详情
			Map<String, Object> requestInfo = new HashMap<>();
			requestInfo.put("stationId", sunlightDto.getId());
			String param = JSON.toJSONString(requestInfo);
			com.alibaba.fastjson.JSONObject jsonObject = requestUtil.getResPonseobj(SoFarConstant.stationUrl,
					SoFarConstant.requestPost, param, null);

			jpStation.setType("家庭户用");// 电站类型
			jpStation.setPrice(jsonObject.get("mergeElectricPrice") != null
					? Double.valueOf(jsonObject.get("mergeElectricPrice").toString())
					: null);// 上网电价
			jpStation.setUserName(jsonObject.get("ownerName") != null ? jsonObject.get("ownerName").toString() : null);// 业主姓名
//            jpStation.setEmail(null);// 邮箱
//            jpStation.setArea();//地区
			Long startOperatingTime = jsonObject.get("startOperatingTime") != null
					? Long.valueOf(jsonObject.get("startOperatingTime").toString())
					: null;
			if (startOperatingTime != null) {
				jpStation.setOnGridTime(new Date(startOperatingTime)); // 并网时间
			}
//            jpStation.setAccessTime();// 接入平台时间
//            jpStation.setStationContact();// 电站联系人
//            jpStation.setModuleCount(); // 组件数量

			jpStation.setUserPhone(
					jsonObject.get("contactPhone") != null ? jsonObject.get("contactPhone").toString() : null);// 业主电话
			jpStation.setCreateTime(sunlightDto.getCreateDate() != null ? new Date(sunlightDto.getCreateDate()) : null); // 创建时间
			jpStation.setSnCode(sunlightDto.getId().toString());// sncode
			jpStation.setCapacity(jsonObject.get("installedCapacity") != null
					? Double.valueOf(jsonObject.get("installedCapacity").toString())
					: null);// 装机容量
			jpStation.setRatedPower(
					sunlightDto.getGenerationPower() != null ? Double.valueOf(sunlightDto.getGenerationPower()) / 1000
							: null);// 额定功率
			String state = "离线";

			if ("NORMAL".equals(sunlightDto.getNetworkStatus())) {
				state = "在线";
			} else if ("ALL_OFFLINE".equals(sunlightDto.getNetworkStatus())) {
				state = "离线";
			}
			jpStation.setState(state);// 状态

			// 获取单个电站历史数据
			// 获取当日数据
			Date date = new Date();
			Calendar calendar = Calendar.getInstance();
			int cDay = calendar.get(Calendar.DAY_OF_MONTH);
			int cMonth = calendar.get(Calendar.MONTH) + 1;
			int cYear = calendar.get(Calendar.YEAR);
			SimpleDateFormat sdfMonth = new SimpleDateFormat("yyyy-MM");
			String month = sdfMonth.format(date);
			Map<String, Object> requestInfoDay = new HashMap<>();
			requestInfoDay.put("startTime", month);
			requestInfoDay.put("endTime", month);
			requestInfoDay.put("stationId", sunlightDto.getId());
			requestInfoDay.put("timeType", 2);
			String paramDay = JSON.toJSONString(requestInfoDay);
			com.alibaba.fastjson.JSONObject jsonObjectDay = requestUtil.getResPonseobj(SoFarConstant.stationhisUrl,
					SoFarConstant.requestPost, paramDay, null);
			if (jsonObjectDay != null && jsonObjectDay.get("stationDataItems") != null) {
				JSONArray monthList = jsonObjectDay.getJSONArray("stationDataItems");
				Stream<JSONObject> stream = monthList.stream().map(element -> (JSONObject) element);
				List<JSONObject> filteredList = stream.filter(obj -> cDay == (obj.getInteger("day")))
						.collect(Collectors.toList());
				if (filteredList != null && filteredList.size() > 0) {
					jpStation.setRealTimePower(filteredList.get(0).getDouble("generationPower") / 1000);
					jpStation.setDayGenerate(filteredList.get(0).getDouble("generationValue"));
					jpStation.setDayPowerUse(filteredList.get(0).getDouble("useValue"));
					jpStation.setDayIncome(filteredList.get(0).getDouble("generationValue") * 0.45);
				}
			}

			// 获取当月数据
			SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy");
			String year = sdfYear.format(date);
			requestInfoDay.put("startTime", year);
			requestInfoDay.put("endTime", year);
			requestInfoDay.put("timeType", 3);
			paramDay = JSON.toJSONString(requestInfoDay);
			com.alibaba.fastjson.JSONObject jsonObjectMonth = requestUtil.getResPonseobj(SoFarConstant.stationhisUrl,
					SoFarConstant.requestPost, paramDay, null);
			if (jsonObjectMonth != null && jsonObjectMonth.get("stationDataItems") != null) {
				JSONArray monthList = jsonObjectMonth.getJSONArray("stationDataItems");
				Stream<JSONObject> stream = monthList.stream().map(element -> (JSONObject) element);
				List<JSONObject> filteredList = stream.filter(obj -> cMonth == (obj.getInteger("month")))
						.collect(Collectors.toList());
				if (filteredList != null && filteredList.size() > 0) {
					jpStation.setMonthGenerate(filteredList.get(0).getDouble("generationValue"));
					jpStation.setMonthPowerUse(filteredList.get(0).getDouble("useValue"));
					jpStation.setMonthIncome(filteredList.get(0).getDouble("generationValue") * 0.45);
				}
			}

			// 获取当年数据
			requestInfoDay.put("timeType", 4);
			paramDay = JSON.toJSONString(requestInfoDay);
			com.alibaba.fastjson.JSONObject jsonObjectYear = requestUtil.getResPonseobj(SoFarConstant.stationhisUrl,
					SoFarConstant.requestPost, paramDay, null);
			if (jsonObjectYear != null && jsonObjectYear.get("stationDataItems") != null) {
				JSONArray monthList = jsonObjectYear.getJSONArray("stationDataItems");
				Stream<JSONObject> stream = monthList.stream().map(element -> (JSONObject) element);
				List<JSONObject> filteredList = stream.filter(obj -> cYear == (obj.getInteger("year")))
						.collect(Collectors.toList());
				if (filteredList != null && filteredList.size() > 0) {
					jpStation.setYearGenerate(filteredList.get(0).getDouble("generationValue"));
					jpStation.setYearPowerUse(filteredList.get(0).getDouble("useValue"));
					jpStation.setYearIncome(filteredList.get(0).getDouble("generationValue") * 0.45);
				}
			}

			// 获取累计数据
			requestInfoDay.put("startTime", cYear - 2);
			paramDay = JSON.toJSONString(requestInfoDay);
			com.alibaba.fastjson.JSONObject jsonObjectAll = requestUtil.getResPonseobj(SoFarConstant.stationhisUrl,
					SoFarConstant.requestPost, paramDay, null);
			if (jsonObjectAll != null && jsonObjectAll.get("stationDataItems") != null) {
				JSONArray monthList = jsonObjectAll.getJSONArray("stationDataItems");
				double all = 0.0;
				if (monthList != null && monthList.size() > 0) {
					for (Object obj : monthList) {
						JSONObject json = (JSONObject) obj;
						all += json.getDouble("generationValue");
					}
				}
				jpStation.setAccumulatedPower(all);
				jpStation.setCumulativeIncome(all * 0.45);
			}

			// 获取所电站下逆变器
			Map<String, Object> requestInfo2 = new HashMap<>();
			requestInfo2.put("stationId", sunlightDto.getId());
			requestInfo2.put("deviceType", "INVERTER");
			requestInfo2.put("page", "1");
			requestInfo2.put("size", "10000");
			String param2 = JSON.toJSONString(requestInfo2);
			List<SofarInverter> jsonObject2 = requestUtil.getResPonse(SoFarConstant.nbqlist, SoFarConstant.requestPost,
					param2, SoFarConstant.deviceListItems, SofarInverter.class);
			if (jsonObject2 != null && jsonObject2.size() > 0) {
				// 获取设备实时数据
				Map<String, Object> requestInfo1 = new HashMap<>();
				requestInfo1.put("deviceSn", jsonObject2.get(0).getDeviceSn());
				String param1 = JSON.toJSONString(requestInfo1);
				List<SofarInverterDto> jsonObject1 = requestUtil.getResPonse(SoFarConstant.currentData,
						SoFarConstant.requestPost, param1, SoFarConstant.dataList, SofarInverterDto.class);
				// 电站 报警状态 值为2
				for (SofarInverter sofarInverter : jsonObject2) {
					if (sofarInverter.getConnectStatus() == 2) {
						jpStation.setState(SoFarConstant.stationStaus.get(sofarInverter.getConnectStatus() + ""));// 电站状态
						break;
					}
				}

				if (jsonObject1 != null && !jsonObject1.isEmpty()) {
					Map<String, String> maps = jsonObject1.stream()
							.collect(Collectors.toMap(SofarInverterDto::getKey, SofarInverterDto::getValue));
//					// 功率
//					jpStation.setRealTimePower(
//							maps != null && maps.containsKey("TPG")
//									? (String.valueOf(maps.get("TPG")) != null
//											? Double.valueOf(maps.get("TPG").toString()) / 1000
//											: null)
//									: null);// 实时功率
//
//					// 日发电量
//					jpStation
//							.setDayGenerate(maps != null && maps.containsKey("Etdy_ge1")
//									? (String.valueOf(maps.get("Etdy_ge1")) != null
//											? Double.valueOf(maps.get("Etdy_ge1").toString())
//											: null)
//									: null);// 日发电量
//					// 累计发电量
//					jpStation
//							.setAccumulatedPower(maps != null && maps.containsKey("Et_ge0")
//									? (String.valueOf(maps.get("Et_ge0")) != null
//											? Double.valueOf(maps.get("Et_ge0").toString())
//											: null)
//									: null);// 累计发电量
//					// 累计发电量
//					jpStation.setAccumulatedPower(jpStation.getDayGenerate() != null
//							? Double.valueOf(jpStation.getDayGenerate().toString()) * 0.45
//							: null);// 日收益
//					// 累计发电量
//					jpStation.setCumulativeIncome(jpStation.getAccumulatedPower() != null
//							? Double.valueOf(jpStation.getAccumulatedPower().toString()) * 0.45
//							: null);// 累计收益

					// 获取月发电量
//					Map<String, Object> requestInfoy = new HashMap<>();
//					requestInfoy.put("deviceSn", jsonObject2.get(0).getDeviceSn());
//					Calendar calendar = Calendar.getInstance();
//					int year = calendar.get(Calendar.YEAR);
//					int month = calendar.get(Calendar.MONTH) + 1;
//					requestInfoy.put("startTime", year + "");
//					requestInfoy.put("endTime", year + "");
//					requestInfoy.put("timeType", 4);
//
//					String paramy = JSON.toJSONString(requestInfoy);
//					List<Sofarhistorical> jsonObjecty = requestUtil.getResPonse(SoFarConstant.currentData,
//							SoFarConstant.requestPost, paramy, SoFarConstant.paramDataList, Sofarhistorical.class);
//
//					if (jsonObjecty != null && jsonObjecty.size() > 0) {
//
//						List<Sofarhistorical> jsonObjectyf = jsonObjecty.stream().filter(da -> Objects.nonNull(da))
//								.filter(da -> da.getCollectTime().equals(month + "")).collect(Collectors.toList());
//						if (!jsonObjectyf.isEmpty()) {
//							for (Sofarhistorical sofarhistorical : jsonObjectyf) {
//								if (sofarhistorical.getDataList().get(0).getKey().equals("generation")) {
//									// 月发电量
//									jpStation.setMonthGenerate(sofarhistorical.getDataList().get(0).getValue() != null
//											? Double.valueOf(sofarhistorical.getDataList().get(0).getValue())
//											: null);
//									// 月收益
//									jpStation.setMonthIncome(
//											jpStation.getMonthGenerate() != null ? jpStation.getMonthGenerate() * 0.45
//													: null);
//
//								}
//							}
//						}
//					}
//
//					// 获取年发电量
//					Map<String, Object> requestInfoyn = new HashMap<>();
//					requestInfoyn.put("deviceSn", jsonObject2.get(0).getDeviceSn());
//					requestInfoyn.put("startTime", year + "");
//					requestInfoyn.put("endTime", year + "");
//					requestInfoyn.put("timeType", 5);
//
//					String paramyn = JSON.toJSONString(requestInfoyn);
//					List<Sofarhistorical> jsonObjectyn = requestUtil.getResPonse(SoFarConstant.currentData,
//							SoFarConstant.requestPost, paramyn, SoFarConstant.paramDataList, Sofarhistorical.class);
//
//					if (jsonObjectyn != null && jsonObjectyn.size() > 0) {
//
//						List<Sofarhistorical> jsonObjectyfn = jsonObjectyn.stream().filter(da -> Objects.nonNull(da))
//								.filter(da -> da.getCollectTime().equals(year + "")).collect(Collectors.toList());
//						if (!jsonObjectyfn.isEmpty()) {
//							for (Sofarhistorical sofarhistorical : jsonObjectyfn) {
//								if (sofarhistorical.getDataList().get(0).getKey().equals("generation")) {
//									// 年发电量
//									jpStation.setYearGenerate(sofarhistorical.getDataList().get(0).getValue() != null
//											? Double.valueOf(sofarhistorical.getDataList().get(0).getValue())
//											: null);
//									// 年月收益
//									jpStation.setYearIncome(
//											jpStation.getYearGenerate() != null ? jpStation.getYearGenerate() * 0.45
//													: null);
//
//								}
//							}
//						}
//					}
					if (!ObjectUtils.isEmpty(jpStation.getSequenceNbr())) {
						jpStationMapper.updateById(jpStation);
					} else {
						jpStationMapper.insert(jpStation);
					}

					String today = DateUtil.today();
					String hour = new Date().getHours() + ":00";
					HYGFJPDayPower hygfjpDayPower = hygfjpDayPowerMapper.selectOne(
							new QueryWrapper<HYGFJPDayPower>().eq("third_station_id", sunlightDto.getId().toString())
									.eq("year_month_day", today).eq("hour", hour));
					if (ObjectUtils.isEmpty(hygfjpDayPower)) {
						hygfjpDayPower = new HYGFJPDayPower();
					}
					hygfjpDayPower.setThirdStationId(sunlightDto.getId().toString());
					hygfjpDayPower.setHour(hour);
					hygfjpDayPower.setYearMonthDay(today);
					hygfjpDayPower.setPower(jpStation.getRealTimePower());
					// 新加
					hygfjpDayPower.setAmosCompanyCode(jpStation.getAmosCompanyCode());
					hygfjpDayPower.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
					hygfjpDayPower.setStationName(jpStation.getName());
					hygfjpDayPower.setStationState(jpStation.getState());

					if (ObjectUtils.isEmpty(hygfjpDayPower.getCreatedTime())) {
						hygfjpDayPower.setCreatedTime(System.currentTimeMillis());
						hygfjpDayPowerMapper.insert(hygfjpDayPower);
					} else {
						hygfjpDayPowerMapper.insert(hygfjpDayPower);
					}

					HYGFJPStationPowerHistory hygfjpStationPowerHistory = new HYGFJPStationPowerHistory();
					hygfjpStationPowerHistory.setCreatedTime(System.currentTimeMillis());
					hygfjpStationPowerHistory.setThirdStationId(jpStation.getThirdStationId());
					hygfjpStationPowerHistory.setPower(jpStation.getRealTimePower());
					hygfjpStationPowerHistory.setThirdCode(jpStation.getThirdCode());
					hygfjpStationPowerHistory.setTime(System.currentTimeMillis());
					// 新加
					hygfjpStationPowerHistory.setAmosCompanyCode(jpStation.getAmosCompanyCode());
					hygfjpStationPowerHistory.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
					hygfjpStationPowerHistory.setStationName(jpStation.getName());
					hygfjpStationPowerHistory.setStationState(jpStation.getState());
					hygfjpStationPowerHistoryMapper.insert(hygfjpStationPowerHistory);

					// 增加td 电站区域公司，经销商绑定表
//                    TdJpStation tdJpStation = tdJpStationMapper.selectOne(new QueryWrapper<TdJpStation>().
//                            eq("third_code",PVProducerInfoEnum.SH.getCode()).
//                            eq("third_station_id",  jpStation.getThirdStationId()));
//                    //判断是否存在
//                    if (ObjectUtils.isEmpty(tdJpStation)) {
//                        tdJpStation = new TdJpStation();
//                    }
//                    tdJpStation.setAmosCompanyCode(jpStation.getAmosCompanyCode());
//                    tdJpStation.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
//                    tdJpStation.setThirdStationId( jpStation.getThirdStationId());
//                    tdJpStation.setThirdCode(PVProducerInfoEnum.SH.getCode());
//                    tdJpStation.setIsDelete(jpStation.getIsDelete()?1:0);
//                    tdJpStation.setStationName(jpStation.getName());
//                    if (!ObjectUtils.isEmpty(tdJpStation.getCreatedTime())) {
//                        tdJpStationMapper.insert(tdJpStation);
//                    } else {
//                        tdJpStation.setCreatedTime(System.currentTimeMillis());
//                        tdJpStationMapper.insert(tdJpStation);
//                    }
// 					Map<String, Object> requestInfo3 = new HashMap<>();
// 					requestInfo3.put("stationId", sunlightDto.getId());
// 					requestInfo3.put("deviceType", "COLLECTOR");
// 					String param3 = JSON.toJSONString(requestInfo3);
// 					List<SofarInverter> jsonObject3 = requestUtil.getResPonse(SoFarConstant.nbqlist,
// 							SoFarConstant.requestPost, param3, SoFarConstant.deviceListItems, SofarInverter.class);
					// 逆变器信信息
					this.inverterList(jsonObject2, jpStation, maps);
					// this.collectorDetail(jsonObject3, jpStation);
					// 报警列表无法获取ruleId了 首航更新接口了
					this.inverAlramInfo(jpStation);
				}
			} else {
				if (!ObjectUtils.isEmpty(jpStation.getSequenceNbr())) {
					jpStationMapper.updateById(jpStation);
				} else {
					jpStationMapper.insert(jpStation);
				}
			}
			// 获取采集器信息
			Map<String, Object> requestInfo3 = new HashMap<>();
			requestInfo3.put("stationId", sunlightDto.getId());
			requestInfo3.put("deviceType", "COLLECTOR");
			String param3 = JSON.toJSONString(requestInfo3);
			List<SofarInverter> jsonObject3 = requestUtil.getResPonse(SoFarConstant.nbqlist,
					SoFarConstant.requestPost, param3, SoFarConstant.deviceListItems, SofarInverter.class);
			// 逆变器信信息
			this.collectorDetail(jsonObject3, jpStation);

			// 电站报表
			// 户用场站日发电量
			Date today1 = new Date();
			TdHYGFStationMonthGenerate TdHYGFStationMonthGenerate = TdHYGFStationMonthGenerateMapper.selectOne(
					new QueryWrapper<TdHYGFStationMonthGenerate>().eq("third_station_id", jpStation.getThirdStationId())
							.eq("day_time", DateUtil.format(today1, "yyyy-MM-dd"))
							.eq("year_month", DateUtil.format(today1, "yyyy-MM")));
			if (ObjectUtils.isEmpty(TdHYGFStationMonthGenerate)) {
				TdHYGFStationMonthGenerate = new TdHYGFStationMonthGenerate();
			}
			TdHYGFStationMonthGenerate.setThirdStationId(jpStation.getThirdStationId());
			TdHYGFStationMonthGenerate.setDayTime(DateUtil.format(today1, "yyyy-MM-dd"));
			TdHYGFStationMonthGenerate.setYearMonth(DateUtil.format(today1, "yyyy-MM"));
			TdHYGFStationMonthGenerate.setGenerate(jpStation.getDayGenerate());

			// 新加
			TdHYGFStationMonthGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
			TdHYGFStationMonthGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
			TdHYGFStationMonthGenerate.setStationName(jpStation.getName());
			TdHYGFStationMonthGenerate.setStationState(jpStation.getState());

			TdHYGFStationMonthGenerate.setFullhour(

					(jpStation.getDayGenerate() == null || jpStation.getCapacity() == null) ? null :

							(jpStation.getCapacity() <= 0.0 ? null
									: jpStation.getDayGenerate() / jpStation.getCapacity())

			);
			TdHYGFStationMonthGenerate.setIncome(jpStation.getDayIncome());
			if (ObjectUtils.isEmpty(TdHYGFStationMonthGenerate.getCreatedTime())) {
				TdHYGFStationMonthGenerate.setCreatedTime(System.currentTimeMillis());
				TdHYGFStationMonthGenerateMapper.insert(TdHYGFStationMonthGenerate);
			} else {
				TdHYGFStationMonthGenerateMapper.insert(TdHYGFStationMonthGenerate);
			}
			// 户用场站月发电量
			TdHYGFStationYearGenerate TdHYGFStationYearGenerate = TdHYGFStationYearGenerateMapper.selectOne(
					new QueryWrapper<TdHYGFStationYearGenerate>().eq("third_station_id", jpStation.getThirdStationId())
							.eq("month_time", DateUtil.format(today1, "yyyy-MM"))
							.eq("year", DateUtil.format(today1, "yyyy")));
			if (ObjectUtils.isEmpty(TdHYGFStationYearGenerate)) {
				TdHYGFStationYearGenerate = new TdHYGFStationYearGenerate();
			}
			TdHYGFStationYearGenerate.setThirdStationId(jpStation.getThirdStationId());
			TdHYGFStationYearGenerate.setMonthTime(DateUtil.format(today1, "yyyy-MM"));
			TdHYGFStationYearGenerate.setYear(DateUtil.format(today1, "yyyy"));
			TdHYGFStationYearGenerate.setGenerate(jpStation.getMonthGenerate());
			TdHYGFStationYearGenerate.setFullhour(
//                    jpStation.getMonthGenerate() / jpStation.getCapacity()
					(jpStation.getMonthGenerate() == null || jpStation.getCapacity() == null) ? null
							: (jpStation.getCapacity() <= 0.0 ? null
									: jpStation.getMonthGenerate() / jpStation.getCapacity()));
			TdHYGFStationYearGenerate.setIncome(jpStation.getMonthIncome());

			// 新加
			TdHYGFStationYearGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
			TdHYGFStationYearGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
			TdHYGFStationYearGenerate.setStationName(jpStation.getName());
			TdHYGFStationYearGenerate.setStationState(jpStation.getState());

			if (ObjectUtils.isEmpty(TdHYGFStationYearGenerate.getCreatedTime())) {
				TdHYGFStationYearGenerate.setCreatedTime(System.currentTimeMillis());
				TdHYGFStationYearGenerateMapper.insert(TdHYGFStationYearGenerate);
			} else {
				TdHYGFStationYearGenerateMapper.insert(TdHYGFStationYearGenerate);
			}
			// 户用场站年发电量
			TdHYGFStationAllGenerate TdHYGFStationAllGenerate = TdHYGFStationAllGenerateMapper.selectOne(
					new QueryWrapper<TdHYGFStationAllGenerate>().eq("third_station_id", jpStation.getThirdStationId())
							.eq("year_time", DateUtil.format(today1, "yyyy"))
							.eq("year", DateUtil.format(today1, "yyyy")));
			if (ObjectUtils.isEmpty(TdHYGFStationAllGenerate)) {
				TdHYGFStationAllGenerate = new TdHYGFStationAllGenerate();
			}
			TdHYGFStationAllGenerate.setThirdStationId(jpStation.getThirdStationId());
			TdHYGFStationAllGenerate.setYearTime(DateUtil.format(today1, "yyyy"));
			TdHYGFStationAllGenerate.setYear(DateUtil.format(today1, "yyyy"));
			TdHYGFStationAllGenerate.setGenerate(jpStation.getYearGenerate());
			TdHYGFStationAllGenerate.setFullhour(
//                    jpStation.getYearGenerate() / jpStation.getCapacity()
					(jpStation.getYearGenerate() == null || jpStation.getCapacity() == null) ? null
							: (jpStation.getCapacity() <= 0.0 ? null
									: jpStation.getYearGenerate() / jpStation.getCapacity()));
			TdHYGFStationAllGenerate.setIncome(jpStation.getYearIncome());
			// 新加
			TdHYGFStationAllGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
			TdHYGFStationAllGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
			TdHYGFStationAllGenerate.setStationName(jpStation.getName());
			TdHYGFStationAllGenerate.setStationState(jpStation.getState());

			if (ObjectUtils.isEmpty(TdHYGFStationAllGenerate.getCreatedTime())) {
				TdHYGFStationAllGenerate.setCreatedTime(System.currentTimeMillis());
				TdHYGFStationAllGenerateMapper.insert(TdHYGFStationAllGenerate);
			} else {
				TdHYGFStationAllGenerateMapper.insert(TdHYGFStationAllGenerate);
			}

		}

	}

	@Override
	public void collectorList() {

	}

	@Override
	public void collectorDetail(List<SofarInverter> devices, JpStation jpStation) {

		new Thread(new Runnable() {
			@Override
			public void run() {
				try {

					for (SofarInverter device : devices) {
						JpCollector jpCollector = jpCollectorMapper.selectOne(new QueryWrapper<JpCollector>()
								.eq("third_station_id", jpStation.getThirdStationId())
								.eq("third_code", PVProducerInfoEnum.SH.getCode()).eq("sn_code", device.getDeviceSn()));
						if (ObjectUtils.isEmpty(jpCollector)) {
							jpCollector = new JpCollector();
						}
						// sn编码
						jpCollector.setSnCode(device.getDeviceSn());
						jpCollector.setAddr(jpStation.getAddress());
						jpCollector.setName(device.getDeviceSn());
						// 类型
						jpCollector.setType("通信模块");
						// 更新时间
						jpCollector.setUpdateTime(new Date());

						// 出场日期
//                jpCollector.setDischargeDate(new Date(collectorDetailDto.getFactoryTime()));
//                //生产日期
//                jpCollector.setProductDate(new Date(collectorDetailDto.getFactoryTime()));
//                //数据上传间隔
//                jpCollector.setDataPeriod(collectorDetailDto.getDataUploadCycle());
//                //本次上电时间
//                jpCollector.setThisWorkTime(new DateTime(collectorDetailDto.getCurrentWorkingTime()));
//                //累计工作时间
//                jpCollector.setTotalWorkTime(new DateTime(collectorDetailDto.getTotalWorkingTime()));
						// 第三方电站id
						jpCollector.setThirdStationId(jpStation.getThirdStationId());
						// 第三方厂商标识
						jpCollector.setThirdCode(PVProducerInfoEnum.SH.getCode());

						if (device.getConnectStatus() != null) {
							jpCollector.setState(SoFarConstant.stationStaus.get(device.getConnectStatus() + ""));// 电站状态
						}
						jpCollector.setStationName(jpStation.getName());
						// jpCollector.setVersion(imasterCollectorList.getSoftwareVersion());
						jpCollector.setRecDate(new Date());
						if (ObjectUtils.isEmpty(jpCollector.getSequenceNbr())) {
							jpCollectorMapper.insert(jpCollector);
						} else {
							jpCollectorMapper.updateById(jpCollector);
						}
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}).start();
	}

	@Override
//    @Async
	public void inverterList(List<SofarInverter> devices, JpStation jpStation, Map<String, String> maps) {
		// 存储逆变器
		new Thread(new Runnable() {
			@Override
			public void run() {
				try {
					for (SofarInverter device : devices) {
						if (device != null) {
							// 获取逆变器信息存库
							JpInverter jpInverter = jpInverterMapper.selectOne(
									new QueryWrapper<JpInverter>().eq("third_station_id", jpStation.getThirdStationId())
											.eq("third_code", PVProducerInfoEnum.SH.getCode())
											.eq("ID", device.getDeviceId().toString()));

							if (ObjectUtils.isEmpty(jpInverter)) {
								jpInverter = new JpInverter();
							}
							// 品牌
							jpInverter.setBrand(null);
							jpInverter.setSnCode(device.getDeviceSn());
							jpInverter.setId(device.getDeviceId().toString());
							if (device.getConnectStatus() != null) {
								jpInverter.setState(SoFarConstant.stationStaus.get(device.getConnectStatus() + ""));// 电站状态
							}

							jpInverter.setUpdateTime(new Date());
							jpInverter.setDayPowerGeneration(jpStation.getDayGenerate());
							jpInverter.setMonthPowerGeneration(jpStation.getMonthGenerate());
							jpInverter.setYearPowerGeneration(jpStation.getYearGenerate());
							jpInverter.setTotalPowerGeneration(jpStation.getAccumulatedPower());
							jpInverter.setThirdStationId(jpStation.getThirdStationId());
							jpInverter.setThirdCode(PVProducerInfoEnum.SH.getCode());
							jpInverter.setName(jpStation.getName());
							jpInverter.setStationName(jpStation.getName());
							jpInverter.setAddr(jpStation.getAddress());
							jpInverter.setModel(null);
							jpInverter.setCapacity(jpStation.getCapacity());
							jpInverter.setCurrentPower(jpStation.getRealTimePower());

							// 获取逆变器铜须关系

							Map<String, Object> requestInfo3 = new HashMap<>();
							requestInfo3.put("deviceSn", device.getDeviceSn());
							String param3 = JSON.toJSONString(requestInfo3);
							JSONObject jsonObject3 = requestUtil.getResPonseobj(SoFarConstant.equipComm,
									SoFarConstant.requestPost, param3, SoFarConstant.communication);

							if (jsonObject3 != null) {
								jpInverter.setCollectorId(jsonObject3.get("plantId").toString());
								// 采集器sn编码
								jpInverter.setCollectorSnCode(jsonObject3.get("parentSn").toString());
							}

//            // 国标
//            jpInverter.setNationalStandard(inverterDetailDto.getNationalStandards());
//            // 满发小时数
//            jpInverter.setGenerationHours(String.valueOf(inverterDetailDto.getFullHour()));
//            //版本
//            jpInverter.setVersion(device.getDevice_model_code());
//            //采集器id
//            jpInverter.setCollectorId(ksolarStationCollectList.getCollectId().trim());
//            //采集器sn编码
//            jpInverter.setCollectorSnCode(ksolarStationCollectList.getCollectId().trim());

							if (!ObjectUtils.isEmpty(jpInverter.getSequenceNbr())) {
								jpInverterMapper.updateById(jpInverter);
							} else {
								if (StringUtils.isNotEmpty(jpInverter.getSnCode())) {
									jpInverterMapper.insert(jpInverter);
								}
							}

							// 逆变器指标信息

							if (maps != null && !maps.isEmpty()) {
								List<String> liname = new ArrayList<>();
								liname.add("AC1");// A 相电压
								liname.add("AC2");// B 相电压
								liname.add("AC3");// C 相电压
								liname.add("PV1");// 直流电压 1
								liname.add("PV2");// 直流电压 2
								liname.add("PV3");// 直流电压 3
								liname.add("PV4");// 直流电压 4
								liname.add("PV5");// 直流电压 5
								liname.add("PV6");// 直流电压 6
								liname.add("PV7");// 直流电压 7
								liname.add("PV8");// 直流电压 8
								liname.add("PV9");// 直流电压 9
								liname.add("PV10");// 直流电压 10
								for (int i = 0; i < liname.size(); i++) {

									JpInverterElectricity jpInverterElectricity = jpInverterElectricityMapper
											.selectOne(new QueryWrapper<JpInverterElectricity>()
													.eq("sn_code", jpInverter.getSnCode())
													.eq("third_code", PVProducerInfoEnum.SH.getCode())
													.eq("name", liname.get(i)));
									if (ObjectUtils.isEmpty(jpInverterElectricity)) {
										jpInverterElectricity = new JpInverterElectricity();
									}
									jpInverterElectricity.setInverterId(jpInverter.getId());
									jpInverterElectricity.setSnCode(jpInverter.getSnCode());
									jpInverterElectricity.setThirdCode(PVProducerInfoEnum.SH.getCode());
									jpInverterElectricity.setThirdStationId(jpInverter.getThirdStationId());

									if (i > 2) {
										jpInverterElectricity.setType("直流");
									} else {
										jpInverterElectricity.setType("交流");
									}

									jpInverterElectricity.setName(liname.get(i));

									String voltage = null;
									String current = null;
									String power = null;
									switch (liname.get(i)) {
									case "AC1":
										voltage = maps.containsKey("AV1") && maps.get("AV1") != null
												? maps.get("AV1").toString()
												: null;
										current = maps.containsKey("AC1") && maps.get("AC1") != null
												? maps.get("AC1").toString()
												: null;
										break;

									case "AC2":
										voltage = maps.containsKey("AV2") && maps.get("AV2") != null
												? maps.get("AV2").toString()
												: null;
										current = maps.containsKey("AC2") && maps.get("AC2") != null
												? maps.get("AC2").toString()
												: null;
										break;
									case "AC3":
										voltage = maps.containsKey("AV3") && maps.get("AV3") != null
												? maps.get("AV3").toString()
												: null;
										current = maps.containsKey("AC3") && maps.get("AC3") != null
												? maps.get("AC3").toString()
												: null;
										break;
									case "PV1":
										voltage = maps.containsKey("DV1") && maps.get("DV1") != null
												? maps.get("DV1").toString()
												: null;
										current = maps.containsKey("DC1") && maps.get("DC1") != null
												? maps.get("DC1").toString()
												: null;
										power = maps.containsKey("DP1") && maps.get("DP1") != null
												? maps.get("DP1").toString()
												: null;
										break;
									case "PV2":
										voltage = maps.containsKey("DV2") && maps.get("DV2") != null
												? maps.get("DV2").toString()
												: null;
										current = maps.containsKey("DC2") && maps.get("DC2") != null
												? maps.get("DC2").toString()
												: null;
										power = maps.containsKey("DP2") && maps.get("DP2") != null
												? maps.get("DP2").toString()
												: null;

										break;
									case "PV3":
										voltage = maps.containsKey("DV3") && maps.get("DV3") != null
												? maps.get("DV3").toString()
												: null;
										current = maps.containsKey("DC3") && maps.get("DC3") != null
												? maps.get("DC3").toString()
												: null;
										power = maps.containsKey("DP3") && maps.get("DP3") != null
												? maps.get("DP3").toString()
												: null;

										break;
									case "PV4":
										voltage = maps.containsKey("DV4") && maps.get("DV4") != null
												? maps.get("DV4").toString()
												: null;
										current = maps.containsKey("DC4") && maps.get("DC4") != null
												? maps.get("DC4").toString()
												: null;
										power = maps.containsKey("DP4") && maps.get("DP4") != null
												? maps.get("DP4").toString()
												: null;

										break;
									case "PV5":
										voltage = maps.containsKey("DV5") && maps.get("DV5") != null
												? maps.get("DV5").toString()
												: null;
										current = maps.containsKey("DC5") && maps.get("DC5") != null
												? maps.get("DC5").toString()
												: null;
										power = maps.containsKey("DP5") && maps.get("DP5") != null
												? maps.get("DP5").toString()
												: null;

										break;
									case "PV6":
										voltage = maps.containsKey("DV6") && maps.get("DV6") != null
												? maps.get("DV6").toString()
												: null;
										current = maps.containsKey("DC6") && maps.get("DC6") != null
												? maps.get("DC6").toString()
												: null;
										power = maps.containsKey("DP6") && maps.get("DP6") != null
												? maps.get("DP6").toString()
												: null;

										break;
									case "PV7":
										voltage = maps.containsKey("DV7") && maps.get("DV7") != null
												? maps.get("DV7").toString()
												: null;
										current = maps.containsKey("DC7") && maps.get("DC7") != null
												? maps.get("DC7").toString()
												: null;
										power = maps.containsKey("DP7") && maps.get("DP7") != null
												? maps.get("DP7").toString()
												: null;

										break;
									case "PV8":
										voltage = maps.containsKey("DV8") && maps.get("DV8") != null
												? maps.get("DV8").toString()
												: null;
										current = maps.containsKey("DC8") && maps.get("DC8") != null
												? maps.get("DC8").toString()
												: null;
										power = maps.containsKey("DP8") && maps.get("DP8") != null
												? maps.get("DP8").toString()
												: null;

										break;
									case "PV9":
										voltage = maps.containsKey("DV9") && maps.get("DV9") != null
												? maps.get("DV9").toString()
												: null;
										current = maps.containsKey("DC9") && maps.get("DC9") != null
												? maps.get("DC9").toString()
												: null;
										power = maps.containsKey("DP9") && maps.get("DP9") != null
												? maps.get("DP9").toString()
												: null;

										break;
									case "PV10":
										voltage = maps.containsKey("DV10") && maps.get("DV10") != null
												? maps.get("DV10").toString()
												: null;
										current = maps.containsKey("DC10") && maps.get("DC10") != null
												? maps.get("DC10").toString()
												: null;
										power = maps.containsKey("DP10") && maps.get("DP10") != null
												? maps.get("DP10").toString()
												: null;

										break;
									default:
									}
									jpInverterElectricity.setVoltage(voltage != null ? Double.valueOf(voltage) : null);
									jpInverterElectricity.setCurrent(current != null ? Double.valueOf(current) : null);
									jpInverterElectricity.setPower(power != null ? Double.valueOf(power) : null);
									if (ObjectUtils.isEmpty(jpInverterElectricity.getSequenceNbr())) {
										jpInverterElectricityMapper.insert(jpInverterElectricity);
									} else {
										jpInverterElectricityMapper.updateById(jpInverterElectricity);
									}
								}
								// 逆变器报表
								// -----------------------户用光伏日报表----------------------
								TdHYGFInverterDayGenerate tdHYGFInverterDayGenerate = new TdHYGFInverterDayGenerate();
								tdHYGFInverterDayGenerate.setCreatedTime(System.currentTimeMillis());
								tdHYGFInverterDayGenerate.setThirdStationId(jpInverter.getThirdStationId());
								tdHYGFInverterDayGenerate.setSnCode(jpInverter.getSnCode());
								tdHYGFInverterDayGenerate.setName(jpInverter.getName());
								tdHYGFInverterDayGenerate.setWorkStatus(jpInverter.getState());
								// 交流电压
								tdHYGFInverterDayGenerate.setDcv1(maps.containsKey("AV1") && maps.get("AV1") != null
										? Double.valueOf(maps.get("AV1").toString())
										: null);
								tdHYGFInverterDayGenerate.setDcv2(maps.containsKey("AV2") && maps.get("AV2") != null
										? Double.valueOf(maps.get("AV2").toString())
										: null);
								tdHYGFInverterDayGenerate.setDcv3(maps.containsKey("AV3") && maps.get("AV3") != null
										? Double.valueOf(maps.get("AV3").toString())
										: null);
								// 交流电流
								tdHYGFInverterDayGenerate.setDcc1(maps.containsKey("AC1") && maps.get("AC1") != null
										? Double.valueOf(maps.get("AC1").toString())
										: null);
								tdHYGFInverterDayGenerate.setDcc2(maps.containsKey("AC2") && maps.get("AC2") != null
										? Double.valueOf(maps.get("AC2").toString())
										: null);
								tdHYGFInverterDayGenerate.setDcc3(maps.containsKey("AC3") && maps.get("AC3") != null
										? Double.valueOf(maps.get("AC3").toString())
										: null);
								// 直流电压
								tdHYGFInverterDayGenerate.setAcv1(maps.containsKey("DV1") && maps.get("DV1") != null
										? Double.valueOf(maps.get("DV1").toString())
										: null);
								tdHYGFInverterDayGenerate.setAcv2(maps.containsKey("DV2") && maps.get("DV2") != null
										? Double.valueOf(maps.get("DV2").toString())
										: null);
								tdHYGFInverterDayGenerate.setAcv3(maps.containsKey("DV3") && maps.get("DV3") != null
										? Double.valueOf(maps.get("DV3").toString())
										: null);
								tdHYGFInverterDayGenerate.setAcv4(maps.containsKey("DV4") && maps.get("DV4") != null
										? Double.valueOf(maps.get("DV4").toString())
										: null);
								// 直流电流
								tdHYGFInverterDayGenerate.setAcc1(maps.containsKey("DC1") && maps.get("DC1") != null
										? Double.valueOf(maps.get("DC1").toString())
										: null);
								tdHYGFInverterDayGenerate.setAcc2(maps.containsKey("DC2") && maps.get("DC2") != null
										? Double.valueOf(maps.get("DC2").toString())
										: null);
								tdHYGFInverterDayGenerate.setAcc3(maps.containsKey("DC3") && maps.get("DC3") != null
										? Double.valueOf(maps.get("DC3").toString())
										: null);
								tdHYGFInverterDayGenerate.setAcc4(maps.containsKey("DC4") && maps.get("DC4") != null
										? Double.valueOf(maps.get("DC4").toString())
										: null);

								tdHYGFInverterDayGenerate.setPv1(maps.containsKey("DP1") && maps.get("DP1") != null
										? Double.valueOf(maps.get("DP1").toString())
										: null);
								tdHYGFInverterDayGenerate.setPv2(maps.containsKey("DP2") && maps.get("DP2") != null
										? Double.valueOf(maps.get("DP2").toString())
										: null);
								tdHYGFInverterDayGenerate.setPv3(maps.containsKey("DP3") && maps.get("DP3") != null
										? Double.valueOf(maps.get("DP3").toString())
										: null);
								tdHYGFInverterDayGenerate.setPv4(maps.containsKey("DP4") && maps.get("DP4") != null
										? Double.valueOf(maps.get("DP4").toString())
										: null);

								// 功率
								tdHYGFInverterDayGenerate.setTotalPower(jpInverter.getCurrentPower());
//                                    //频率
								tdHYGFInverterDayGenerate
										.setFrequency(maps.containsKey("A_Fo1") && maps.get("A_Fo1") != null
												? String.valueOf(maps.get("A_Fo1"))
												: null);
//                                    //功率因数
								tdHYGFInverterDayGenerate.setPowerFactor(1.0);
								tdHYGFInverterDayGenerate.setDayGen(jpInverter.getDayPowerGeneration());
								tdHYGFInverterDayGenerate.setMonthGen(jpInverter.getMonthPowerGeneration());
								tdHYGFInverterDayGenerate.setYearGen(jpInverter.getYearPowerGeneration());
								tdHYGFInverterDayGenerate.setTotalGen(jpInverter.getTotalPowerGeneration());
								tdHYGFInverterDayGenerate
										.setIgbtTemp(ObjectUtils.isEmpty(jpInverter.getIgbtTemperature()) ? null
												: Double.valueOf(jpInverter.getIgbtTemperature()));
								tdHYGFInverterDayGenerate.setIncome(null);
								tdHYGFInverterDayGenerate.setFullhour(
										(jpInverter.getDayPowerGeneration() == null || jpInverter.getCapacity() == null)
												? null
												: (jpInverter.getCapacity() <= 0.0 ? null
														: jpInverter.getDayPowerGeneration()
																/ jpInverter.getCapacity()));

								// 电站区域经销商，
								JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>()
										.eq("third_code", PVProducerInfoEnum.SH.getCode())
										.eq("third_station_id", String.valueOf(jpInverter.getThirdStationId())));

								if (jpStation != null) {
									tdHYGFInverterDayGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
									tdHYGFInverterDayGenerate
											.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
									tdHYGFInverterDayGenerate.setStationName(jpStation.getName());
									tdHYGFInverterDayGenerate.setStationState(jpStation.getState());

								}

								tdHYGFInverterDayGenerateMapper.insert(tdHYGFInverterDayGenerate);
								// 户用场站月发电量
								Date today1 = new Date();
								TdHYGFInverterMonthGenerate tdHYGFInverterMonthGenerate = tdHYGFInverterMonthGenerateMapper
										.selectOne(new QueryWrapper<TdHYGFInverterMonthGenerate>()
												.eq("third_station_id", jpInverter.getThirdStationId())
												.eq("sn_code", jpInverter.getSnCode())
												.eq("day_time", DateUtil.format(today1, "yyyy-MM-dd"))
												.eq("year_month", DateUtil.format(today1, "yyyy-MM")));
								if (ObjectUtils.isEmpty(tdHYGFInverterMonthGenerate)) {
									tdHYGFInverterMonthGenerate = new TdHYGFInverterMonthGenerate();
								}
								tdHYGFInverterMonthGenerate.setThirdStationId(jpInverter.getThirdStationId());
								tdHYGFInverterMonthGenerate.setSnCode(jpInverter.getSnCode().trim());
								tdHYGFInverterMonthGenerate.setDayTime(DateUtil.format(today1, "yyyy-MM-dd"));
								tdHYGFInverterMonthGenerate.setYearMonth(DateUtil.format(today1, "yyyy-MM"));
								tdHYGFInverterMonthGenerate.setGenerate(jpInverter.getDayPowerGeneration());
								tdHYGFInverterMonthGenerate.setName(jpInverter.getName());
								tdHYGFInverterMonthGenerate.setFullhour(
										(jpInverter.getDayPowerGeneration() == null || jpInverter.getCapacity() == null)
												? null
												: (jpInverter.getCapacity() <= 0.0 ? null
														: jpInverter.getDayPowerGeneration()
																/ jpInverter.getCapacity()));

								// 新加
								if (jpStation != null) {
									tdHYGFInverterMonthGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
									tdHYGFInverterMonthGenerate
											.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
									tdHYGFInverterMonthGenerate.setStationName(jpStation.getName());
									tdHYGFInverterMonthGenerate.setStationState(jpStation.getState());

								}
								if (ObjectUtils.isEmpty(tdHYGFInverterMonthGenerate.getCreatedTime())) {
									tdHYGFInverterMonthGenerate.setCreatedTime(System.currentTimeMillis());
									tdHYGFInverterMonthGenerateMapper.insert(tdHYGFInverterMonthGenerate);
								} else {
									tdHYGFInverterMonthGenerateMapper.insert(tdHYGFInverterMonthGenerate);
								}
								// 户用场站年发电量
								TdHYGFInverterYearGenerate tdHYGFInverterYearGenerate = tdHYGFInverterYearGenerateMapper
										.selectOne(new QueryWrapper<TdHYGFInverterYearGenerate>()
												.eq("third_station_id", jpInverter.getThirdStationId())
												.eq("sn_code", jpInverter.getSnCode())
												.eq("month_time", DateUtil.format(today1, "yyyy-MM"))
												.eq("year", DateUtil.format(today1, "yyyy")));
								if (ObjectUtils.isEmpty(tdHYGFInverterYearGenerate)) {
									tdHYGFInverterYearGenerate = new TdHYGFInverterYearGenerate();
								}
								tdHYGFInverterYearGenerate.setThirdStationId(jpInverter.getThirdStationId());
								tdHYGFInverterYearGenerate.setSnCode(jpInverter.getSnCode().trim());
								tdHYGFInverterYearGenerate.setMonthTime(DateUtil.format(today1, "yyyy-MM"));
								tdHYGFInverterYearGenerate.setYear(DateUtil.format(today1, "yyyy"));
								tdHYGFInverterYearGenerate.setGenerate(jpInverter.getMonthPowerGeneration());
								tdHYGFInverterYearGenerate.setName(jpInverter.getName());
								tdHYGFInverterYearGenerate.setFullhour((jpInverter.getMonthPowerGeneration() == null
										|| jpInverter.getCapacity() == null)
												? null
												: (jpInverter.getCapacity() <= 0.0 ? null
														: jpInverter.getMonthPowerGeneration()
																/ jpInverter.getCapacity()));

								// 新加
								if (jpStation != null) {
									tdHYGFInverterYearGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
									tdHYGFInverterYearGenerate
											.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
									tdHYGFInverterYearGenerate.setStationName(jpStation.getName());
									tdHYGFInverterYearGenerate.setStationState(jpStation.getState());

								}

								if (ObjectUtils.isEmpty(tdHYGFInverterYearGenerate.getCreatedTime())) {
									tdHYGFInverterYearGenerate.setCreatedTime(System.currentTimeMillis());
									tdHYGFInverterYearGenerateMapper.insert(tdHYGFInverterYearGenerate);
								} else {
									tdHYGFInverterYearGenerateMapper.insert(tdHYGFInverterYearGenerate);
								}
								// 户用场站年发电量
								TdHYGFInverterTotalGenerate tdHYGFInverterTotalGenerate = tdHYGFInverterTotalGenerateMapper
										.selectOne(new QueryWrapper<TdHYGFInverterTotalGenerate>()
												.eq("third_station_id", jpInverter.getThirdStationId())
												.eq("sn_code", jpInverter.getSnCode())
												.eq("year_time", DateUtil.format(today1, "yyyy"))
												.eq("year", DateUtil.format(today1, "yyyy")));
								if (ObjectUtils.isEmpty(tdHYGFInverterTotalGenerate)) {
									tdHYGFInverterTotalGenerate = new TdHYGFInverterTotalGenerate();
								}
								tdHYGFInverterTotalGenerate.setThirdStationId(jpInverter.getThirdStationId());
								tdHYGFInverterTotalGenerate.setSnCode(jpInverter.getSnCode().trim());
								tdHYGFInverterTotalGenerate.setYearTime(DateUtil.format(today1, "yyyy"));
								tdHYGFInverterTotalGenerate.setYear(DateUtil.format(today1, "yyyy"));
								tdHYGFInverterTotalGenerate.setGenerate(jpInverter.getYearPowerGeneration());
								tdHYGFInverterTotalGenerate.setFullhour(0.0d);
								tdHYGFInverterTotalGenerate.setName(jpInverter.getName());
								tdHYGFInverterTotalGenerate.setFullhour((jpInverter.getYearPowerGeneration() == null
										|| jpInverter.getCapacity() == null)
												? null
												: (jpInverter.getCapacity() <= 0.0 ? null
														: jpInverter.getYearPowerGeneration()
																/ jpInverter.getCapacity()));
								if (ObjectUtils.isEmpty(tdHYGFInverterTotalGenerate.getCreatedTime())) {
									tdHYGFInverterTotalGenerate.setCreatedTime(System.currentTimeMillis());
									tdHYGFInverterTotalGenerateMapper.insert(tdHYGFInverterTotalGenerate);
								} else {
									tdHYGFInverterTotalGenerateMapper.insert(tdHYGFInverterTotalGenerate);
								}
							}
						}
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}).start();

	}

	@Override
	public void inverterDetail() {

	}

	@Override
	@Async
	public void inverAlramInfo(JpStation jpStation) {
		SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
		String date = shortSdf.format(new Date());
		Map<String, Object> requestInfo = new HashMap<>();
		requestInfo.put("page", 1);
		requestInfo.put("size", 99);
		requestInfo.put("startTime", date);
		requestInfo.put("endTime", date);
		requestInfo.put("stationId", jpStation.getThirdStationId());

   
//		if (jpStation.getThirdStationId().equals("517021808701218816")){
//			System.out.println("6666666666666666666666666");
//		}
		List<SofarWarm> jsonObject2 = requestUtil.getResPonseList(SoFarConstant.alert, SoFarConstant.requestPost, requestInfo,
				SoFarConstant.stationAlertItems, SofarWarm.class);
//		if (jsonObject2 != null && jsonObject2.size() > 0) {
//			System.out.println("88888888888888888888888");
//		}
		for (SofarWarm sofarWarm : jsonObject2) {
			if (sofarWarm.getDeviceType().equals("INVERTER") || sofarWarm.getDeviceType().equals("COLLECTOR")) {
				HYGFJPInverterWarn hygfjpInverterWarn = new HYGFJPInverterWarn();
				hygfjpInverterWarn.setTime(System.currentTimeMillis());
				hygfjpInverterWarn.setSnCode(sofarWarm.getDeviceSn());
				hygfjpInverterWarn.setThirdStationId(jpStation.getThirdStationId());
				hygfjpInverterWarn.setLevel(SofarRequestUtil.alarmLevel.get(sofarWarm.getLevel().toString()));
				hygfjpInverterWarn.setWarnId(sofarWarm.getRuleId().toString());
				hygfjpInverterWarn.setAmosCompanyCode(jpStation.getAmosCompanyCode());
				hygfjpInverterWarn.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
				hygfjpInverterWarn.setStationName(jpStation.getName());
				hygfjpInverterWarn.setStationState(jpStation.getState());
				hygfjpInverterWarn.setCreatedTime(System.currentTimeMillis());
				hygfjpInverterWarn.setThirdCode(PVProducerInfoEnum.SH.getCode());
				// 告警詳情
				Map<String, Object> requestInfo1 = new HashMap<>();
				requestInfo1.put("addr", sofarWarm.getAddr());
				requestInfo1.put("deviceSn", sofarWarm.getDeviceSn());
				requestInfo1.put("alertTime", sofarWarm.getAlertTime());
				String param1 = JSON.toJSONString(requestInfo1);
				JSONObject jsonObject21 = requestUtil.getResPonseobj(SoFarConstant.alertDetail,
						SoFarConstant.requestPost, param1, null);
				hygfjpInverterWarn.setContent(jsonObject21.get("alertName").toString());
				hygfjpInverterWarn.setTreatment(jsonObject21.get("solution").toString());

				if ("1".equals(jsonObject21.get("alarmState").toString())) {
					hygfjpInverterWarn.setState("已处理");
				} else {
					hygfjpInverterWarn.setState("未处理");
				}

				if (!ObjectUtils.isEmpty(jsonObject21.get("restoreTime"))) {
					hygfjpInverterWarn.setRecoverTime(Long.valueOf(jsonObject21.get("restoreTime").toString()));
				}

				if (!ObjectUtils.isEmpty(jsonObject21.get("alertTime"))) {
					hygfjpInverterWarn.setStartTime(Long.valueOf(jsonObject21.get("alertTime").toString()));
				}
				hygfjpInverterWarn.setTimeLong(null);
				if ((!ObjectUtils.isEmpty(jsonObject21.get("alertTime")))
						&& (!ObjectUtils.isEmpty(jsonObject21.get("restoreTime")))) {
					hygfjpInverterWarn.setTimeLong(this.convertDate(hygfjpInverterWarn.getRecoverTime())
							- this.convertDate(hygfjpInverterWarn.getStartTime()));
				}
				if (ObjectUtils.isEmpty(hygfjpInverterWarn.getCreatedTime())) {
					hygfjpInverterWarn.setCreatedTime(System.currentTimeMillis());
					hygfjpInverterWarnMapper.insert(hygfjpInverterWarn);
				} else {
					hygfjpInverterWarnMapper.insert(hygfjpInverterWarn);
				}
			}

		}

	}

	public Long convertDate(Long input) {
		Long result = 0L;
		Date date = DateUtil.date(input);
		result = DateUtil.parse(DateUtil.format(date, DatePattern.NORM_DATETIME_PATTERN)).getTime();
		return result;
	}
}
