package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.yeejoin.amos.boot.module.common.api.feign.AmosTrainingFeignClient;
import com.yeejoin.amos.boot.module.common.api.feign.EquipFeignClient;
import com.yeejoin.amos.boot.module.jcs.api.mapper.FireResourceSupervisionMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IFireResourceSupervisionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class FireResourceSupervisionServiceImpl implements IFireResourceSupervisionService {

    @Autowired
    private FireResourceSupervisionMapper fireResourceSupervisionMapper;

    @Autowired
    private AmosTrainingFeignClient examFeign;

    /**
     * 获取人员统计信息
     *
     * @param bizOrgCode 机构编码
     */
    @Override
    public Map<String, Map<String, Number>> getPersonnelStats(String bizOrgCode) {
        List<Map<String, Object>> maps = fireResourceSupervisionMapper.selectPersonnelStats(bizOrgCode);
        Long attendanceCount = fireResourceSupervisionMapper.selectTodayAttendance(bizOrgCode);
        Map<String, Map<String, Number>> result = new HashMap<>();

        for (Map<String, Object> map : maps) {
            Object peopleType = map.get("peopleType");
            if (Objects.isNull(peopleType)) {
                continue;
            }

            long totalCount = Long.parseLong(map.get("totalCount").toString());
            long certifiedCount = Long.parseLong(map.get("certifiedCount").toString());

            String key;
            switch (peopleType.toString()) {
                case "0":
                    key = "operationStats";
                    break;
                case "1":
                    key = "fireStats";
                    break;
                default:
                    continue;
            }
            Map<String, Number> stats = getStringNumberMap(certifiedCount, totalCount, attendanceCount, key);
            result.put(key, stats);
        }

        return result;
    }

    private Map<String, Number> getStringNumberMap(long certifiedCount, long totalCount, Long attendanceCount, String key) {
        Map<String, Number> stats = new HashMap<>();
        stats.put("totalCount", totalCount);
        stats.put("certifiedRate", calculateRate(certifiedCount, totalCount));
        stats.put("attendanceRate", calculateRate(attendanceCount, totalCount));
        ResponseModel<List<String>> response = null;
        try {
            response = examFeign.getUserIdList();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (0 < response.getResult().size()) {
            BigDecimal ratePercent;
            if ("operationStats".equals(key)) {
                List<String> ywNum = fireResourceSupervisionMapper.getYwPersonNum();
                List<String> result = ywNum.stream().filter(response.getResult()::contains).collect(Collectors.toList());
                BigDecimal total = new BigDecimal(String.valueOf(ywNum.size()));
                BigDecimal zzExamCount = new BigDecimal(String.valueOf(result.size()));
                ratePercent = zzExamCount.divide(total, 2, BigDecimal.ROUND_HALF_UP);
            } else {
                List<String> zzNum = fireResourceSupervisionMapper.getZzPersonNum();
                List<String> result = zzNum.stream().filter(response.getResult()::contains).collect(Collectors.toList());
                BigDecimal total = new BigDecimal(String.valueOf(zzNum.size()));
                BigDecimal zzExamCount = new BigDecimal(String.valueOf(result.size()));
                ratePercent = zzExamCount.divide(total, 2, BigDecimal.ROUND_HALF_UP);
            }
            stats.put("monthStudyRate", ratePercent);
        } else {
            stats.put("monthStudyRate", BigDecimal.ZERO);
        }
        return stats;
    }

    private BigDecimal calculateRate(Number numerator, Number denominator) {
        BigDecimal rate = new BigDecimal(numerator.toString())
                .divide(new BigDecimal(denominator.toString()), 4, RoundingMode.HALF_UP)
                .multiply(new BigDecimal(100))
                .setScale(2, RoundingMode.HALF_UP);
        return rate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : rate;
    }
}
