package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDate;
import java.util.Date;

/**
 *
 *
 * @author hzz
 * @date 2024-09-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_repayment", autoResultMap = true)
public class Repayment extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 公司名称
     */
    @TableField("company_name")
    private String companyName;
    /**
     * 公司CODE
     */
    @TableField("regional_companies_code")
    private String regionalCompaniesCode;
    /**
     * 公司ID
     */
    @TableField("company_id")
    private Long companyId;
    /**
     * 期次
     */
    @TableField("period")
    private String period;
    /**
     * 还款时间
     */
    @TableField("repay_date")
    private LocalDate repayDate;
    /**
     * 租金
     */
    @TableField("rent")
    private Double rent;
    /**
     * 利息
     */
    @TableField("interest")
    private Double interest;
    /**
     * 本金
     */
    @TableField("principal")
    private Double principal;
    /**
     * 放款批次
     */
    @TableField("loan_period")
    private String loanPeriod;
    /**
     * 消息状态0未确认1已确认
     */
    @TableField("message_state")
    private Integer messageState;
    /**
     * 还款状态0未还款1已还款
     */
    @TableField("repay_state")
    private Integer repayState;
    /**
     * 定时发送状态
     */
    @TableField("cron_send_state")
    private Integer cronSendState;


}
