package com.yeejoin.amos.boot.module.hygf.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 农户信息 Mapper 接口
 *
 * @author system_generator
 * @date 2023-07-07
 */
public interface PeasantHouseholdMapper extends BaseMapper<PeasantHousehold> {
    List<PeasantHousehold> selectPeasantHouseholdList(@Param("developerId") Long developerId,
                                                      @Param("regionalCompaniesSeq")Long regionalCompaniesSeq,
                                                      @Param("peasantHouseholdNo")String peasantHouseholdNo,
                                                      @Param("ownersName")String ownersName,
                                                      @Param("ids")String ids,
                                                      @Param("orderBy") String orderBy
    );
    List<PeasantHousehold> selectPeasantHouseholdListsg(@Param("unitInfoCode") String unitInfoCode,
                                                      @Param("regionalCompaniesSeq")Long regionalCompaniesSeq,
                                                      @Param("peasantHouseholdNo")String peasantHouseholdNo,
                                                      @Param("ownersName")String ownersName,
                                                        @Param("ids")String ids

    );
    @UserEmpower(field={},dealerField={"developer_code","regional_companies_code","developer_user_id"} ,fieldConditions ={"eq","in","eq"} ,relationship="and")
    List<PeasantHousehold> queryForPage( String developerCode,String ownersName,Long developerId,Integer isCertified,String preparationMoneyState, String peasantHouseholdNo,String province);


    List<Map<String,Object>> selectUserIsHouse(String telephone);

    Integer selectIsAllRevoke(String peasantHouseholdNo);
    Integer selectIsAllRevokePassCount(String peasantHouseholdNo);

    void deleteHphByUserId(String userId);
    void deletePauByUserId(String userId);
    void deleteAliByUserId(String userId);
    void deleteHhcByUserId(String userId);

    PeasantHousehold selectReview(String sequenceNbr);

     Integer selectPowerStationNumber(String amosUserId);

    void deleteHphByNo(String peasantHouseholdNo);

    void deleteHhcByNo(String peasantHouseholdNo);

    List<PeasantHousehold> getInfoByIds(@Param(value = "ids") List<String> ids);
//    String getHygfCommercialScale(Long surveyInformationId);
}
