//package com.yeejoin.amos.workflow.config;
//
//import com.baomidou.mybatisplus.core.config.GlobalConfig;
//import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
//import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
//import com.github.pagehelper.PageInterceptor;
//import com.yeejoin.amos.boot.biz.config.MetaHandler;
//import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpowerInterceptor;
//import com.zaxxer.hikari.HikariDataSource;
//import io.seata.rm.datasource.DataSourceProxy;
//import org.apache.ibatis.plugin.Interceptor;
//import org.apache.ibatis.session.SqlSessionFactory;
//import org.mybatis.spring.SqlSessionTemplate;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.beans.factory.annotation.Qualifier;
//import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
//import org.springframework.boot.context.properties.ConfigurationProperties;
//import org.springframework.boot.jdbc.DataSourceBuilder;
//import org.springframework.context.annotation.Bean;
//import org.springframework.context.annotation.Configuration;
//import org.springframework.context.annotation.Primary;
//import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
//import org.springframework.core.io.support.ResourcePatternResolver;
//import org.springframework.jdbc.datasource.DataSourceTransactionManager;
//
//import javax.sql.DataSource;
//import java.util.Properties;
//
///**
// * 数据源代理
// *
// * @author LiuLin
// */
//@Configuration
//public class DataSourceConfiguration {
//    @Autowired
//    MetaHandler metaHandler;
//    private static final String MAPPER_LOCATION = "classpath*:mapper/mysql/*.xml";
//
//    @Autowired
//    private DataSourceProperties dsp;
//
//    @Bean(name = "mysqlDataSource")
//    @Primary
//    public DataSource mysqlDataSource() {
//        HikariDataSource hds = new HikariDataSource();
//        hds.setUsername(dsp.getUsername());
//        hds.setPassword(dsp.getPassword());
//        hds.setJdbcUrl(dsp.getUrl());
//        hds.setDriverClassName(dsp.getDriverClassName());
//        hds.setConnectionTimeout(3000);
//        hds.setMaximumPoolSize(30);
//        hds.setMinimumIdle(10);
//        return hds;
//    }
//
//    @Bean("mysqlDataSourceProxy")
//    public DataSourceProxy dataSourceProxy(DataSource hikariDataSource) {
//        return new DataSourceProxy(hikariDataSource);
//    }
//
//    @Bean(name = "mysqlSqlSessionFactory")
//    @Primary
//    public SqlSessionFactory mysqlSqlSessionFactory(@Qualifier("mysqlDataSourceProxy") DataSource dataSource, GlobalConfig globalConfig) throws Exception {
//        //注意这里一定要用MybatisSqlSessionFactoryBean，如果用SqlSessionFactory，配置无效
//        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
//        bean.setDataSource(dataSource);
//        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(MAPPER_LOCATION));
//        globalConfig.setMetaObjectHandler(metaHandler);
//        bean.setGlobalConfig(globalConfig);
//        //分页插件
//        Interceptor interceptor = new PageInterceptor();
//        Properties properties = new Properties();
//        properties.setProperty("helperDialect", "mysql");
//        properties.setProperty("offsetAsPageNum", "true");
//        properties.setProperty("rowBoundsWithCount", "true");
//        properties.setProperty("reasonable", "true");
//        properties.setProperty("supportMethodsArguments","true");
//        properties.setProperty("params","pageNum=current;pageSize=size" +
//                "" +
//                ";");
//        interceptor.setProperties(properties);
//        bean.setPlugins(new Interceptor[] {interceptor,
//                userEmpowerInterceptor(),
//                paginationInterceptor()
//        });
//        return bean.getObject();
//    }
//
//    @Bean(name = "mysqlTransactionManager")
//    @Primary
//    public DataSourceTransactionManager mysqlTransactionManager(@Qualifier("mysqlDataSource") DataSource dataSource) {
//        return new DataSourceTransactionManager(dataSource);
//    }
//
//    @Bean(name = "mysqlSqlSessionTemplate")
//    @Primary
//    public SqlSessionTemplate mysqlSqlSessionTemplate(@Qualifier("mysqlSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
//        return new SqlSessionTemplate(sqlSessionFactory);
//    }
//
//    @Bean
//    public PaginationInterceptor paginationInterceptor() {
//        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
//        paginationInterceptor.setDialectType("mysql");
//        return paginationInterceptor;
//    }
//
//
//    @Bean
//    public UserEmpowerInterceptor userEmpowerInterceptor() {
//        UserEmpowerInterceptor userEmpowerInterceptor = new UserEmpowerInterceptor();
//
//        return userEmpowerInterceptor;
//    }
//
//
//}
