package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.BasicGridAuditingServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.BasicGridAuditingDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 并网审核表
 *
 * @author system_generator
 * @date 2024-08-21
 */
@RestController
@Api(tags = "并网审核表Api")
@RequestMapping(value = "/basic-grid-auditing")
public class BasicGridAuditingController extends BaseController {

    @Autowired
    BasicGridAuditingServiceImpl basicGridAuditingServiceImpl;

    /**
     * 新增并网审核表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增并网审核表", notes = "新增并网审核表")
	public ResponseModel<BasicGridAuditingDto> save(@RequestBody BasicGridAuditingDto model) {
	    model = basicGridAuditingServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新并网审核表", notes = "根据sequenceNbr更新并网审核表")
	public ResponseModel<BasicGridAuditingDto> updateBySequenceNbrBasicGridAuditing(@RequestBody BasicGridAuditingDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(basicGridAuditingServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除并网审核表", notes = "根据sequenceNbr删除并网审核表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(basicGridAuditingServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个并网审核表",  notes = "根据sequenceNbr查询单个并网审核表")
	public ResponseModel<BasicGridAuditingDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(basicGridAuditingServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "并网审核表分页查询",  notes = "并网审核表分页查询")
	public ResponseModel<Page<BasicGridAuditingDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<BasicGridAuditingDto> page = new Page<BasicGridAuditingDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(basicGridAuditingServiceImpl.queryForBasicGridAuditingPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "并网审核表列表全部数据查询",   notes = "并网审核表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<BasicGridAuditingDto>> selectForList() {
	    return ResponseHelper.buildResponse(basicGridAuditingServiceImpl.queryForBasicGridAuditingList());
	}
}
