package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.yeejoin.amos.boot.module.hygf.api.dto.CommerceInfoDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.FinancingInfoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@RestController
@Api(tags = "公共接口")
@RequestMapping(value = "/common")
public class CommonController {

    @Autowired
    FinancingInfoServiceImpl financingInfoService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/selectRegion")
    @ApiOperation(httpMethod = "GET", value = "查询全国省份", notes = "查询全国省份")
    public ResponseModel<List<Map<String,Object>>> selectRegion() {
        return ResponseHelper.buildResponse(financingInfoService.selectRegion());
    }




}
