package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.DocumentBomDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.DocumentBomServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 发货单bom
 *
 * @author system_generator
 * @date 2023-08-17
 */
@RestController
@Api(tags = "发货单bomApi")
@RequestMapping(value = "/document-bom")
public class DocumentBomController extends BaseController {

    @Autowired
    DocumentBomServiceImpl documentBomServiceImpl;

    /**
     * 新增发货单bom
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增发货单bom", notes = "新增发货单bom")
	public ResponseModel<DocumentBomDto> save(@RequestBody DocumentBomDto model) {
	    model = documentBomServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新发货单bom", notes = "根据sequenceNbr更新发货单bom")
	public ResponseModel<DocumentBomDto> updateBySequenceNbrDocumentBom(@RequestBody DocumentBomDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(documentBomServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除发货单bom", notes = "根据sequenceNbr删除发货单bom")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(documentBomServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个发货单bom",  notes = "根据sequenceNbr查询单个发货单bom")
	public ResponseModel<DocumentBomDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(documentBomServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "发货单bom分页查询",  notes = "发货单bom分页查询")
	public ResponseModel<Page<DocumentBomDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<DocumentBomDto> page = new Page<DocumentBomDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(documentBomServiceImpl.queryForDocumentBomPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "发货单bom列表全部数据查询",   notes = "发货单bom列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<DocumentBomDto>> selectForList() {
	    return ResponseHelper.buildResponse(documentBomServiceImpl.queryForDocumentBomList());
	}

	/**
	 * 根据货单id查询BOM清单
	 *
	 *
	 * @param preparationMoneyId preparationMoneyId
	 * @return {@link  ResponseModel< List< DocumentBomDto>>}
	 * @author Provence
	 * @throws
	 * @date 2023/8/17 20:33
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据货单id查询BOM清单", notes = "根据货单id查询BOM清单")
	@GetMapping(value = "/listByPreparationMoneyId")
	public ResponseModel<Page<DocumentBomDto>> listByPreparationMoneyId(@RequestParam(value = "current") int current,@RequestParam
			(value = "size") int size,@RequestParam Long preparationMoneyId) {
		Page<DocumentBomDto> page = new Page<DocumentBomDto>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(documentBomServiceImpl.queryForDocumentBomPage(page, preparationMoneyId));
	}
}
