package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.Enum.RepaymentCronSendStateEnum;
import com.yeejoin.amos.boot.module.hygf.api.Enum.RepaymentMessageStateEnum;
import com.yeejoin.amos.boot.module.hygf.api.Enum.RepaymentRepayStateEnum;
import com.yeejoin.amos.boot.module.hygf.api.dto.RepaymentDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.Repayment;
import com.yeejoin.amos.boot.module.hygf.api.util.FileUtil;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.RepaymentServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 *
 *
 * @author 还款管理
 * @date 2024-09-26
 */
@RestController
@Api(tags = "还款管理Api")
@RequestMapping(value = "/repayment")
public class RepaymentController extends BaseController {
    @Autowired
    RepaymentServiceImpl repaymentService;

    /**
     * 定时任务
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/cronTest")
    @ApiOperation(httpMethod = "GET", value = "定时任务", notes = "定时任务")
    public ResponseModel<?> cronTest() {
        repaymentService.cronSendRepayMessage();
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<RepaymentDto> save(@RequestBody RepaymentDto model) {
        model.setCronSendState(RepaymentCronSendStateEnum.SEND.getCode());
        model.setMessageState(RepaymentMessageStateEnum.UN_CONFIRM.getCode());
        model.setRepayState(RepaymentRepayStateEnum.UN_REPAY.getCode());
        model = repaymentService.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/updateBySequenceNbr")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<?> updateBySequenceNbr(@RequestBody Repayment model) {
        repaymentService.updateById(model);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr确认消息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/messageBySequenceNbr")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr确认消息", notes = "根据sequenceNbr确认消息")
    public ResponseModel<?> confirmMessageState(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        repaymentService.confirmMessageState(sequenceNbr);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr还款
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/repayBySequenceNbr")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr还款", notes = "根据sequenceNbr还款")
    public ResponseModel<?> batchRepay(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        repaymentService.repay(sequenceNbr);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr批量确认消息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/batchConfirmMessageState")
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr批量确认消息", notes = "根据sequenceNbr批量确认消息")
    public ResponseModel<?> batchConfirmMessageState(@RequestBody List<Long> sequenceNbrList) {
        repaymentService.batchConfirmMessageState(sequenceNbrList);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr批量还款
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/batchRepay")
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr批量还款", notes = "根据sequenceNbr批量还款")
    public ResponseModel<?> batchRepay(@RequestBody List<Long> sequenceNbrList) {
        repaymentService.batchRepay(sequenceNbrList);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr批量删除
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "batchDelete")
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr批量删除", notes = "根据sequenceNbr批量删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestBody List<Long> sequenceNbrList) {
        return ResponseHelper.buildResponse(repaymentService.deleteBatchSeq(sequenceNbrList));
    }

    /**
     * 导入还款模板Excel
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "importRepaymentExcel")
    @ApiOperation(httpMethod = "POST", value = "导入还款模板Excel", notes = "导入还款模板Excel")
    public ResponseModel<?> importRepaymentExcel(@RequestPart("file") MultipartFile file) {
        AgencyUserModel userInfo = getUserInfo();
        repaymentService.importRepaymentExcel(file, userInfo);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 导入还款模板Excel
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "exportRepaymentExcel")
    @ApiOperation(httpMethod = "POST", value = "导出还款模板Excel", notes = "导出还款模板Excel")
    public ResponseModel<?> exportRepaymentExcel(@RequestBody List<Long> sequenceNbrList, HttpServletResponse response) {
        repaymentService.exportRepaymentExcel(sequenceNbrList, response);
        return ResponseHelper.buildResponse(null);
    }

    @GetMapping(value = "/exportTemplates")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "模板下载", notes = "模板下载")
    public void exportTemplates(HttpServletResponse response) {
        FileUtil.downloadResource("还款管理导入模板.xlsx", "templates/repaymentTemplates.xlsx", response);
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(repaymentService.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr  主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/selectDetail")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<RepaymentDto> selectOne(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        RepaymentDto repaymentDto = repaymentService.queryBySeq(sequenceNbr);
        return ResponseHelper.buildResponse(repaymentDto);
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<RepaymentDto>> queryForPage(@RequestParam(value = "current") int current,
                                                          @RequestParam(value = "size") int size) {
        return ResponseHelper.buildResponse(repaymentService.queryForRepaymentPage(current, size));
    }
}
