package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.HealthStatusIndicatorServiceImpl;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IndicatorData;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.TdengineTimeServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2.FanHealthIndexMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2.FanWaringRecordMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2.PvHealthIndexMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2.PvWaringRecordMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanWarningRecord;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.PvHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.PvWarningRecord;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.IndicatorDataMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.utils.TimeRangeUtil;

import cn.hutool.core.date.DateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/test")
@Api(tags = "测试Api")
public class TestController extends BaseController {
	@Autowired
	IndicatorDataMapper indicatorDataMapper;
	@Autowired
	CommonServiceImpl commonService;
	@Autowired
	HealthStatusIndicatorServiceImpl healthStatusIndicatorService;

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "test1", notes = "test1")
	@GetMapping("/test1")
	public List<IndicatorData> test1(@RequestParam(value = "startTime") String startTime,
			@RequestParam(value = "endTime") String endTime, @RequestParam(value = "address") String address,
			@RequestParam(value = "gatewayId") String gatewayId) {

		List<IndicatorData> indicatorData = indicatorDataMapper.selectDataByAddressAndtime(address, startTime, endTime,
				gatewayId);

		return indicatorData;
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "test2", notes = "test1")
	@GetMapping("/test2")
	public void test2(@RequestParam(value = "startTime") String startTime, @Param("recDate") String recDate) {
//        List<FanHealthIndex> infoListByGroupByCD = fanHealthIndexMapper.getInfoListByGroupByCdFan(startTime, recDate);
//        commonService.healthWarningMinuteByFJ();
//        commonService.healthWarningMinuteByPv();
//        return infoListByGroupByCD;
	}

	@Autowired
	FanHealthIndexMapper fanHealthIndexMapper;

	@Autowired
	TdengineTimeServiceImpl tdengineTimeService;

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "test2", notes = "test1")
	@GetMapping("/testDay")
	public void test2() throws ParseException {
        tdengineTimeService.insertDayData();
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "saveTest", notes = "saveTest")
	@PostMapping("/saveTest")
	public void saveTest() {

//        QueryWrapper<FanHealthIndex> fanHealthIndexQueryWrapper = new QueryWrapper<>();
//        List<FanHealthIndex> fanHealthIndices = fanHealthIndexMapper.selectList(fanHealthIndexQueryWrapper);
//
//        List<IdxBizFanHealthIndex> list = new ArrayList<>();
//        IdxBizFanHealthIndex fanHealthIndex = new IdxBizFanHealthIndex();
//        fanHealthIndex.setHealthIndex(2.0);
////        fanHealthIndex.setTs(System.currentTimeMillis());
//        fanHealthIndex.setArae("区域");
//        fanHealthIndex.setAnalysisEndTime(DateUtil.date());
//        fanHealthIndex.setAnalysisObjSeq("2");
//        fanHealthIndex.setHealthLevel("2321");
//        fanHealthIndex.setHealthIndex(25.0);
//        fanHealthIndex.setAnalysisStartTime(DateUtil.date());
//        fanHealthIndex.setAnalysisObjType("21");
//        fanHealthIndex.setANALYSISTIME("21");
//        fanHealthIndex.setANOMALY(2.0);
//        fanHealthIndex.setEquipmentName("21");
//        fanHealthIndex.setGatewayId("213412");
//        fanHealthIndex.setPointName("21312");
//        fanHealthIndex.setNumber("213");
//        fanHealthIndex.setKks("213");
//        fanHealthIndex.setRecDate(DateUtil.date());
//        fanHealthIndex.setSubSystem("213421");
//        fanHealthIndex.setWeigth(2.2);
//        fanHealthIndex.setAnalysisType("按时刻");
//        fanHealthIndex.setStation("rwwrrw");
//        fanHealthIndex.setIndexAddress("2321");
//        FanHealthIndex fanHealthIndex1 = new FanHealthIndex();
//        BeanUtil.copyProperties(fanHealthIndex, fanHealthIndex1);
//        fanHealthIndex1.setWeight(fanHealthIndex.getWeigth());
//        fanHealthIndex1.setAnomaly(fanHealthIndex.getANOMALY());
//        fanHealthIndex1.setRecDate(DateUtil.now());
//        fanHealthIndex1.setArea(fanHealthIndex.getArae());
//        fanHealthIndex1.setAnalysisTime(DateUtil.now());
//        fanHealthIndex1.setHealthLevel(fanHealthIndex.getHealthLevel());
//        fanHealthIndex1.setKks("123456");
//        ArrayList<FanHealthIndex> fanHealthIndices1 = new ArrayList<>();
//        fanHealthIndices1.add(fanHealthIndex1);
//        list.add(fanHealthIndex);
////        commonService.healthWarningMinuteByFJ();
//        fanHealthIndexMapper.saveBatchHealthIndexList(fanHealthIndices1, "fan_health_index_moment");
	}

	@Autowired
	private FanWaringRecordMapper fanWaringRecordMapper;

	@Autowired
	private PvWaringRecordMapper pvWaringRecordMapper;

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "test2", notes = "test1")
	@GetMapping("/clear-record")
	public void clearRecord(@RequestParam(value = "startTime", required = false) String startTime) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String d = sdf.format(new Date());
		LambdaQueryWrapper<FanWarningRecord> wf = new LambdaQueryWrapper<>();
		wf.ne(FanWarningRecord::getDisposotionState, "已确认");
		List<FanWarningRecord> list = fanWaringRecordMapper.selectList(wf);
		if (!list.isEmpty()) {
			list.forEach(i -> {
				i.setDisposotionState("已确认");
				i.setDisposotionDate(d);
			});
			fanWaringRecordMapper.saveBatchWarningRecords(list);
		}

		LambdaQueryWrapper<PvWarningRecord> pf = new LambdaQueryWrapper<>();
		pf.ne(PvWarningRecord::getDisposotionState, "已确认");
		List<PvWarningRecord> list1 = pvWaringRecordMapper.selectList(pf);
		if (!list1.isEmpty()) {
			list1.forEach(i -> {
				i.setDisposotionState("已确认");
				i.setDisposotionDate(d);
			});
			pvWaringRecordMapper.saveBatchWarningRecords(list1);
		}
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "test2", notes = "test1")
	@GetMapping("/test123")
	public void clearRecord() {
		Date time = new Date();
		time = DateUtil.offsetMinute(time, -DateUtil.minute(time) % 10);
		String format = DateUtil.format(time, "yyyy-MM-dd HH:mm:00");
		time = DateUtil.parse(format, "yyyy-MM-dd HH:mm:00");
		healthStatusIndicatorService.healthWarningMinuteGF(time);
	}

	@TycloudOperation(ApiLevel = UserType.PUBLIC, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "insertMomentDataTest", notes = "insertMomentDataTest", hidden = true)
	@GetMapping("/insertMomentDataTest")
	public void insertMomentData() {
		try {
			Date time = new Date();
			time = DateUtil.offsetMinute(time, -DateUtil.minute(time) % 10);
			String format = DateUtil.format(time, "yyyy-MM-dd HH:mm:00");
			time = DateUtil.parse(format, "yyyy-MM-dd HH:mm:00");
			tdengineTimeService.insertMomentDataTest("2024-07-24 08:00:00");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@TycloudOperation(ApiLevel = UserType.PUBLIC, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "insertMomentDataPvTest", notes = "insertMomentDataPvTest", hidden = true)
	@GetMapping("/insertMomentDataPvTest")
	public void insertMomentDataPvTest() {
		try {
			Date time = new Date();
			time = DateUtil.offsetMinute(time, -DateUtil.minute(time) % 10);
			String format = DateUtil.format(time, "yyyy-MM-dd HH:mm:00");
			time = DateUtil.parse(format, "yyyy-MM-dd HH:mm:00");
			tdengineTimeService.insertMomentDataPvTest("2024-07-24 08:00:00");

			//区域 全域最后统一生成
			tdengineTimeService.insertMomentDataAllTest("2024-07-24 08:00:00");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Autowired
	PvHealthIndexMapper pvHealthIndexMapper;
	
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "test2", notes = "test1")
	@GetMapping("/clear-health-cf")
	public void clearHealthCf(@RequestParam(value = "startTime", required = false) String startTime)
			throws ParseException {
		List<String> type = new ArrayList<>();
		type.add("按10分钟");
		type.add("按小时");
		type.add("按天");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		List<String> mList = TimeRangeUtil.getMomentInfo(sdf.parse(startTime), new Date());
		for (String d : mList) {
			LambdaQueryWrapper<FanHealthIndex> wf = new LambdaQueryWrapper<>();
			wf.eq(FanHealthIndex::getAnalysisTime, d);
			wf.orderByAsc(FanHealthIndex::getTs);
			wf.eq(FanHealthIndex::getAnalysisObjType, "测点");
			for (String s : type) {
				wf.eq(FanHealthIndex::getAnalysisType, s);
				List<FanHealthIndex> list = fanHealthIndexMapper.selectList(wf);
				Map<String, List<FanHealthIndex>> lm = list.stream()
						.collect(Collectors.groupingBy(FanHealthIndex::getIndexAddress));
				for (Entry<String, List<FanHealthIndex>> m : lm.entrySet()) {
					List<FanHealthIndex> pl = m.getValue();
					if (pl.size() > 1) {
						pl = pl.subList(1, pl.size());
					}
					List<Long> ts = pl.stream().map(FanHealthIndex::getTs).collect(Collectors.toList());
					LambdaQueryWrapper<FanHealthIndex> df = new LambdaQueryWrapper<>();
					for (Long ts1 : ts) {
						df.eq(FanHealthIndex::getTs, ts1);
						fanHealthIndexMapper.delete(df);
					}
				}
			}

			LambdaQueryWrapper<PvHealthIndex> pf = new LambdaQueryWrapper<>();
			pf.eq(PvHealthIndex::getAnalysisTime, d);
			pf.orderByAsc(PvHealthIndex::getTs);
			pf.eq(PvHealthIndex::getAnalysisObjType, "测点");
			for (String s : type) {
				pf.eq(PvHealthIndex::getAnalysisType, s);
				List<PvHealthIndex> listp = pvHealthIndexMapper.selectList(pf);
				Map<String, List<PvHealthIndex>> lmp = listp.stream()
						.collect(Collectors.groupingBy(PvHealthIndex::getIndexAddress));
				for (Entry<String, List<PvHealthIndex>> m : lmp.entrySet()) {
					List<PvHealthIndex> pl = m.getValue();
					if (pl.size() > 1) {
						pl = pl.subList(1, pl.size());
					}
					List<Long> ts = pl.stream().map(PvHealthIndex::getTs).collect(Collectors.toList());
					LambdaQueryWrapper<PvHealthIndex> df = new LambdaQueryWrapper<>();
					for (Long ts1 : ts) {
						df.eq(PvHealthIndex::getTs, ts1);
						pvHealthIndexMapper.delete(df);
					}
				}
			}
		}
	}
}
